/**
    @file startup_gamemanager.h

    Prototypes for GameManager.

    Copyright (c) 2004, 2005 Nokia Corporation.
	
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef STARTUP_GAMEMANAGER_H
#define STARTUP_GAMEMANAGER_H

#include <glib.h>
#include <string.h>
#include "startup_state.h"
#include "startup_communication.h"
#include "ui/interface.h"
#include "dbus.h"
#include "settings.h"

/* Definations for game types
 */
#define GAME_CHESS     "chess"
#define GAME_MAHJONG   "mahjong"
#define GAME_LMARBLES  "marbles"
#define GAME_SWEEPER   "sweeper"

/* Game state messages
 */
enum {
  GAME_RUN=1,
  GAME_CONTINUE,
  GAME_RESTART,
  GAME_CLOSE,
  GAME_SAVE,
  GAME_LOAD
};

/* Game save result
 */
enum {
  GAME_SAVE_NONE=1,
  GAME_SAVE_SAVING,
  GAME_SAVE_OK,
  GAME_SAVE_ERR,
  GAME_SAVE_CANCEL
};

/* Game load result
 */
enum {
  GAME_LOAD_FILE_UNSUPPORTED=1,
  GAME_LOAD_FILE_NOT_FOUND
};

/* Object paths of games
 */
#define OBJECT_PATH_INVALID  "/bin/false"
#define OBJECT_PATH_CHESS    "/com/nokia/osso_chess"
#define OBJECT_PATH_MAHJONG  "/com/nokia/osso_mahjong"
#define OBJECT_PATH_LMARBLES "/com/nokia/osso_lmarbles"
#define OBJECT_PATH_SWEEPER "/br/org/indt/maemosweper"

#define SERVICE_INVALID     ""
#define SERVICE_CHESS       "com.nokia.osso_chess"
#define SERVICE_MAHJONG     "com.nokia.osso_mahjong"
#define SERVICE_LMARBLES    "com.nokia.osso_lmarbles"
#define SERVICE_SWEEPER    "br.org.indt.maemosweper"

#define IFACE_INVALID  ""
#define IFACE_CHESS    "com.nokia.osso_chess"
#define IFACE_MAHJONG  "com.nokia.osso_mahjong"
#define IFACE_LMARBLES "com.nokia.osso_lmarbles"
#define IFACE_SWEEPER "br.org.indt.sweeper"

#define CHESS_SAVE_FILE_TMP "/tmp/osso_chess.tmp"

#define URI_FILE_PREFIX   "file://"
#define MMC_MOUNTPOINT_ENV "MMC_MOUNTPOINT"

#define STARTUP_INIT_PLUGIN(plugininfo, gs, close, open_save) \
    G_MODULE_EXPORT gboolean startup_init_plugin(StartupPlugin *plugin) { \
        plugin->info = &(plugininfo); \
        plugin->gs = &(gs); \
        plugin->send_game_close = close; \
        plugin->menu_open_save = open_save; \
        if (!plugin->info || !plugin->gs) \
          return FALSE; \
        return TRUE; \
    }

/**Fill the plugin structure. It could be needed by other games*/
void Fill_Plugin_Settings(void);
	
	
void
startup_app_set_top_cb (AppUIData  *app,
                        startup_app_top_cb *top_cb,
                        gpointer     data);

void 
startup_app_set_state_change_cb (AppUIData  *app,
                                 startup_app_state_change_cb *state_change_cb,
                                 gpointer     data);

/**
   Startup the plugin, and initialize the structure.
   @param path The path to the plugin to be loaded.
   @returns A filled StartupPlugin structure.
 */
StartupPlugin *startup_plugin_load (const gchar *path);

/**
   Sets the game state_change_cb.
   
   @param state The state of the game.
*/
void set_gamestate(GameState state);

/**
 Called when starting a INDT game,

 @param app Application Data
 */
AppUIData *
Initialize_INDT_settings (AppUIData *app);

/**
 Start game play

 */
void game_play(void);

/**
 Continue paused game

 */
void game_continue(void);

/**
 Restart ongoing game

 */
void game_restart(void);

/**
 Close ongoing game

 */
void game_close(void);

/**
 Called when state changed

 @param state New state
 */
void game_state_changed(GameState state);

/**
 Selects the game type by the given parameter

 @param type game type as string
 */
void set_game_type(GameType type);

/**
 Get selected game type

 @returns Game type
 */
GameType get_game_type(void);

/**
 Get game state

 @returns Game state
 */
GameState get_game_state(void);

/**
 Returns the service of current game

 @returns Service as string
 */
GString *game_get_service(void);

/**
 Returns the interface of current game

 @returns Interface as string
 */
GString *game_get_iface(void);

/**
 Returns the object path of current game

 @returns Object path as string
 */
GString *game_get_object_path(void);

void game_mime_open(gchar *filename);

#endif
