/**
    @file startup_gamemanager.c

    Implements GameManager module.

    Copyright (c) 2004, 2005 Nokia Corporation.
    Parts of this file (c) 2004 INDT
	
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/


#include <glib/gstdio.h>
//#include <hildon/hildon-file-handling-note.h>
#include "startup_gamemanager.h"

/* State information */
GameType game_type = gt_none;
GameState game_state = gs_unloaded;

/* The following function is from INDT's games-startup code. The copyrights 
belongs to them. The INDT's games-startup was released under LGPL license*/

void 
startup_app_set_state_change_cb (AppUIData  *app,
                                 startup_app_state_change_cb *state_change_cb,
                                 gpointer     data)
{
  g_return_if_fail (app != NULL);
  app->state_change_cb = state_change_cb;
  app->state_change_cb_data = data;
}

/* The following function is from INDT's games-startup code. The copyrights 
belongs to them. The INDT's games-startup was released under LGPL license*/

void
startup_app_set_top_cb (AppUIData  *app,
                        startup_app_top_cb *top_cb,
                        gpointer     data)
{
  g_return_if_fail (app != NULL);
  app->top_cb = top_cb;
  app->top_cb_data = data;
}

/* The following function is from INDT's games-startup code. The copyrights 
belongs to them. The INDT's games-startup was released under LGPL license*/

/* Startup the plugin, and initialize the structure */
StartupPlugin *
startup_plugin_load (const gchar *path)
{
  StartupPlugin *plugin;
  GModule *handle;
  gboolean (*startup_init_plugin) ();

  g_return_val_if_fail (path != NULL, NULL);

  handle = g_module_open (path, 0);
  g_assert (handle);

  if (!g_module_symbol (handle,
        "startup_init_plugin",
        (gpointer) &startup_init_plugin)) {
    g_module_close (handle);
			g_print("Symbol can't be found\n");
    return NULL;
  }
  
  plugin = g_new0 (StartupPlugin, 1);
  g_assert (plugin);

  plugin->priv = g_new0 (StartupPluginPrivate, 1);
  g_assert (plugin->priv);
  plugin->priv->handle = handle;

  if (startup_init_plugin (plugin)) 
    return plugin;

  g_module_close (plugin->priv->handle);
  g_free (plugin->priv);
  g_free (plugin);
    
  return NULL;
}

void Fill_Plugin_Settings(void)
{
	AppData *appdata=get_app_data();
	AppUIData *ui=appdata->app_ui_data;
	ui->plugin->gs->ui->app=g_new0(StartupApp,1);
	ui->plugin->gs->ui->app->osso=appdata->app_osso_data->osso;
	  ui->plugin->gs->ui->app->state=get_game_state();
	  ui->plugin->gs->ui->app->top_cb=ui->top_cb;
	  ui->plugin->gs->ui->app->top_cb_data=ui->top_cb_data;
	  ui->plugin->gs->ui->app->state_change_cb=ui->state_change_cb;
	  ui->plugin->gs->ui->app->state_change_cb_data=ui->state_change_cb_data;
	  ui->plugin->gs->ui->app->service=ui->service;
	  ui->plugin->gs->ui->app->path=ui->path;
	  ui->plugin->gs->ui->app->iface=ui->iface;
	ui->plugin->gs->ui->app->config=ui->indt_startup_config;
	ui->plugin->gs->ui->plugin=ui->plugin;
	ui->plugin->gs->ui->hildon_app=ui->app;
	ui->plugin->gs->ui->hildon_appview=ui->main_view;
	ui->plugin->gs->ui->controls_state_label=ui->controls_state_label;
	ui->plugin->gs->ui->play_button=ui->play_button;
	ui->plugin->gs->ui->restart_button=ui->restart_button;
}

/* The following function is from INDT's games-startup code. The copyrights 
belongs to them. The INDT's games-startup was released under LGPL license. 
This function is modified under LGPL license*/

/* Initialize the INDT specific settings */
AppUIData *
Initialize_INDT_settings (AppUIData *ui)
{ 
  //StartupUI *ui;
	//AppData *ui;
	
  const gchar *plugin_path;
  /*const gchar *game_gettext_package;
  const gchar *msgid;*/
  g_return_val_if_fail (ui != NULL, NULL);

  //ui = g_new0 (StartupUI, 1);
	//ui = g_new0 (AppData, 1);
  g_assert (ui);

  //ui->app_ui_data = app;
  startup_app_set_top_cb (ui, startup_ui_top_cb, (gpointer) ui);
  startup_app_set_state_change_cb (ui, startup_ui_state_change_cb, (gpointer) ui);
  plugin_path = startup_config_read_entry (startup_app_get_config (ui), "PluginPath", NULL);
  if (plugin_path){
    ui->plugin = startup_plugin_load (plugin_path);
    //ui->plugin->gs->ui = ui; /*this structure differs from our, so it won't b only 1 line
	  ui->plugin->gs->ui=g_new0 (StartupUI, 1);
	  
    ui->plugin->gs->startup_ui_menu_action_cb = startup_ui_menu_action_cb;
    ui->plugin->gs->startup_ui_state_change_cb = startup_ui_state_change_cb;
  } else 
    ui->plugin = NULL;
  return ui;
}

void game_play(void)
{
  AppData *app_data = get_app_data();
	//osso_rpc_t ret;
  
  game_state = gs_running;
  osso_log(LOG_DEBUG,"game_play called!!!");
  if (set_game_state_async(GAME_RUN)==TRUE) {
    /* Reset save file location */
    settings_set_string(SETTINGS_CHESS_SAVE_FILE,"");

    if (app_data!=NULL)
      app_data->app_ui_data->chess_saved = FALSE;
  } else {
    /* Setting game state unloaded */
    game_state = gs_unloaded;

    /* TODO Should user be informed somehow? */
  }
}

void game_continue(void)
{
  AppData *app_data = get_app_data();

  game_state = gs_running;
  if (set_game_state_async(GAME_CONTINUE)) {
    if (app_data!=NULL)
      app_data->app_ui_data->chess_saved = FALSE;
  } else {
    game_state = gs_unloaded;
  }
}

void game_restart(void)
{
  AppData *app_data = get_app_data();
  
  game_state = gs_running;  
  if (set_game_state_async(GAME_RESTART)) {
    /* Reset save file location */
    settings_set_string(SETTINGS_CHESS_SAVE_FILE,"");

    if (app_data!=NULL)
      app_data->app_ui_data->chess_saved = FALSE;
  } else {
    game_state = gs_unloaded;
  }
}

void game_close(void)
{
  if (game_state!=gs_closed && game_state!=gs_unloaded) {
    if (set_game_state(GAME_CLOSE, NULL)) {
      game_state = gs_closed;
    } else {
      game_state = gs_unloaded;
    }
  }
}


/* Game state changes, set state and update UI */
void game_state_changed(GameState state)
{
  osso_log (LOG_DEBUG, "%s\n", __FUNCTION__);
  game_state = state;
  ui_repaint(get_app_data());
  gtk_window_present(GTK_WINDOW(get_app_data()->app_ui_data->main_view));
}

/* Set the game state */
void set_gamestate(GameState state)
{
	game_state=state;
	return;
}

/* Set game type to one of supported ones */
void set_game_type(GameType type)
{
	game_type=type;
	return;

}

/* Return selected game type */
GameType get_game_type(void)
{
  return game_type;
}

/* Return game state */
GameState get_game_state(void)
{
  return game_state;
}

/* Return selected game object path */
GString *game_get_object_path(void)
{
  GString *path = g_string_new(get_app_data()->app_ui_data->path);
  g_assert(path);
  return path;
}

/* Return selected game object path */
GString *game_get_service(void)
{
  GString *path = g_string_new(get_app_data()->app_ui_data->service);
  g_assert(path);
  return path;
}

/* Return selected game object path */
GString *game_get_iface(void)
{
  GString *path = g_string_new(get_app_data()->app_ui_data->iface);
  g_assert(path);
  return path;
}

void game_mime_open(gchar *filename) 
{
  AppUIData *app_ui_data = get_app_data()->app_ui_data;
	
    /* The loading takes too much time. Make insensitive all during the load */
    app_ui_data->plugin->info->plugin_cb(NULL,(gpointer)MA_GAME_PLAYING_START);
    gtk_widget_set_sensitive(app_ui_data->play_button,FALSE);
    while(gtk_events_pending())
        gtk_main_iteration();
    
    app_ui_data->plugin->info->plugin_cb(NULL,(gpointer)MA_WAIT_FOR_SAVE);
    if ((get_game_state() != gs_running)) {
        /* Show startup screen */
        gtk_window_present(GTK_WINDOW(app_ui_data->main_view));
        while(gtk_events_pending())
            gtk_main_iteration();
    }
	
    if (get_game_state() == gs_running) {
        return;
    }
    
	settings_set_string(SETTINGS_CHESS_SAVE_FILE, filename);
	app_ui_data->plugin->info->plugin_cb(NULL,(gpointer)MA_SETTING_RECENT_ITEMS);
	game_state = gs_running;
	app_ui_data->plugin->info->plugin_cb(NULL,(gpointer)MA_LOAD_MIME);
    app_ui_data->plugin->info->plugin_cb(NULL,(gpointer)MA_GAME_PLAYING);
}
