/**
    @file main.c

    Application main.

    Copyright (c) 2004, 2005 Nokia Corporation.
	
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "main.h"
#include "state_save.h"

#include <stdio.h>
// #include <libgnomevfs/gnome-vfs.h>



static void releaseAppData(AppData *appdata) {
    if (appdata!=NULL) {
        if (appdata->app_ui_data!=NULL) {
            g_free(appdata->app_ui_data);
            appdata->app_ui_data = NULL;
        }

        if (appdata->app_osso_data!=NULL) {
            g_free(appdata->app_osso_data);
            appdata->app_osso_data=NULL;
        }

        if (appdata->app_gconf_data!=NULL) {
            g_free(appdata->app_gconf_data);
            appdata->app_gconf_data=NULL;
        }
        g_free(appdata);
        appdata = NULL;
    }
}

int
main(int argc, char **argv)
{
    AppData *app_data = NULL;
    setlocale(LC_ALL, "");
    bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);

    gtk_init(&argc, &argv);

    set_game_type(gt_indt);

    app_data = g_new0(AppData, 1);
    app_data->app_ui_data = g_new0(AppUIData, 1);
    app_data->app_osso_data = g_new0(AppOSSOData, 1);
    app_data->app_gconf_data = g_new0(AppGConfData, 1);


    /* argv[1] is the config file passed to the games launcher */
    startup_app_set_config_file(app_data, argv[1]);
    app_data->app_ui_data = Initialize_INDT_settings(app_data->app_ui_data);

    /* Init osso */
    if (!init_osso(app_data))
    {
        puts("OSSO init failed");
        releaseAppData(app_data);
        return 1;
    }

    /* Init settings */
    if (!init_settings(app_data))
    {
        puts("Settings init failed");
        releaseAppData(app_data);
        return 1;
    }

    /* Create Hildon window */
    ui_create_main_window(app_data);

    Fill_Plugin_Settings();
    gtk_main();

    // game_close();
    deinit_osso(app_data);
    deinit_settings();

    if (app_data->app_ui_data->timeout > 0)
    {
        g_source_remove(app_data->app_ui_data->timeout);
    }

    if (app_data->app_ui_data->chess_save_folder) 
    {
        g_free(app_data->app_ui_data->chess_save_folder);
    }
    
    if (app_data->app_ui_data->plugin)
    {
        g_free(app_data->app_ui_data->service);
        g_free(app_data->app_ui_data->path);
        g_free(app_data->app_ui_data->iface);
    }

    releaseAppData(app_data);

    return 0;
}
