/**
    @file debug.h

    Implementation of the user interface functions.

    Copyright (c) 2004, 2005 Nokia Corporation.
	
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef DEBUG_H
#define DEBUG_H
#include <stdio.h>
#include <time.h>

#define DEBUG_NONE //no debug message
//#define DEBUG_GLIB //use glib subsystem for the debug messages
//#define DEBUG_FILE //save the debug messages into a file

#ifdef DEBUG_NONE

#define DMSG(args...) 

#endif

#ifdef DEBUG_GLIB

#define DMSG(args...) g_message(args...)

#endif

#ifdef DEBUG_FILE

#define DMSG(args...) do { \
	printf(args); \
	FILE *bla; \
  	bla=fopen("/tmp/testgstup.txt","a+"); \
	fprintf (bla, "%d: ",(int)time(NULL)); \
  	fprintf (bla, args); \
	fflush(bla); \
	fclose(bla); \
	} while (0)

#endif

#endif
