
#include <glib.h>

#include "scwsmileys.h"

static ScwSmileyTree *
_smiley_tree_new (gchar c)
{
  ScwSmileyTree *new = (ScwSmileyTree *) g_new0 (ScwSmileyTree, 1);
  new->c = c;
  new->smiley = NULL;
  new->children = NULL;
  return new;
}

ScwSmileyTree *
scw_smiley_tree_new ()
{
  return _smiley_tree_new ('\0');
}

static ScwSmileyTree *
_smiley_tree_find_child (ScwSmileyTree *tree, gchar c)
{
  GSList *i;

  for (i = tree->children; NULL!= i; i = i->next)
    {
        ScwSmileyTree *child = (ScwSmileyTree *) i->data;

        if (child->c == c)
          return child;
    }

  return NULL;
}

static ScwSmileyTree *
_smiley_tree_find_or_insert_child (ScwSmileyTree *tree, gchar c)
{
  ScwSmileyTree *child = _smiley_tree_find_child (tree, c);

  if (NULL == child)
    {
      child = _smiley_tree_new (c);
      tree->children = g_slist_prepend (tree->children, child);
    }

  return child;
}

ScwSmileyTree *
_smiley_tree_insert (ScwSmileyTree *tree, gchar *s, gchar *smiley)
{
  ScwSmileyTree *child = _smiley_tree_find_or_insert_child (tree, *s);

  g_assert ('\0' != s[0]);

  if ('\0' == s[1])
    {
      child->smiley = smiley;
      return child;
    }

  return _smiley_tree_insert (child, s + 1, smiley);
}

ScwSmileyTree *
scw_smiley_tree_insert (ScwSmileyTree *tree, gchar *s, gchar *smiley)
{
  return _smiley_tree_insert (tree, s, g_strdup (smiley));
}

static ScwMaybeSmiley *
_smiley_maybe_new (gboolean is_smiley, gchar *str)
{
  ScwMaybeSmiley *new = g_new0 (ScwMaybeSmiley, 1);
  new->is_smiley = is_smiley;
  new->str = str;
  return new;
}

GSList *
scw_smiley_tree_replace (ScwSmileyTree *tree, const gchar *s)
{
  gchar *t;
  gchar *cur_str = s;
  ScwSmileyTree *cur_tree = tree;
  GSList *maybes = NULL;

  for (t = s; '\0' != *t; t++)
    {
      ScwSmileyTree *child = _smiley_tree_find_child (cur_tree, *t);

      if (cur_tree == tree)
        {
          if (NULL != child)
            {
              if (t > cur_str)
                maybes = g_slist_append (maybes,
                  _smiley_maybe_new (FALSE, g_strndup (cur_str, t - cur_str)));
              cur_str = t;
              cur_tree = child;
            }

          continue;
        }

      if (NULL != child)
        {
          cur_tree = child;
        }
      else if (NULL != cur_tree->smiley)
        {
          maybes = g_slist_append (maybes,
            _smiley_maybe_new (TRUE, g_strdup (cur_tree->smiley)));
          cur_str = t;
          cur_tree = _smiley_tree_find_child (tree, *t);

          if (NULL == cur_tree)
            cur_tree = tree;
        }
      else
        {
          maybes = g_slist_append (maybes,
            _smiley_maybe_new (FALSE, g_strndup (cur_str, t - cur_str)));
          cur_str = t;
          cur_tree = tree;
        }
    }

  if (cur_tree->smiley)
    maybes = g_slist_append (maybes,
      _smiley_maybe_new (TRUE, g_strdup (cur_tree->smiley)));
  else
    maybes = g_slist_append (maybes,
      _smiley_maybe_new (FALSE, g_strndup (cur_str, t - cur_str)));

  return maybes;
}

