/**
 * @file ui_prefs.c program preferences
 *
 * Copyright (C) 2004 Nathan J. Conrad <t98502@users.sourceforge.net>
 * Copyright (C) 2004 Lars Lindner <lars.lindner@gmx.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <hildon-widgets/hildon-time-editor.h>

#include <settings.h>

#include "conf.h"
#include "interface.h"
#include "support.h"
#include "ui_mainwindow.h"
#include "ui_itemlist.h"
#include "ui_prefs.h"
#include "ui_mainwindow.h"
#include "htmlview.h"
#include "callbacks.h"
#include "main.h"

//extern GSList *availableBrowserModules;
extern AppData *app_data;

/* unused variables
#define MAX_UPDATE_INTERVAL 5

const gint all_cache_size[] = {1, 2, 4, 8, 0};
const gint all_autoupdate_time[] = {15, 30, 1*60, 2*60, 4*60, 8*60};
static GtkWidget *prefdialog = NULL;
*/
//struct browser { 
//    gchar *id;	   /**< Unique ID used in storing the prefs */
//    gchar *display;	/**< Name to display in the prefs */
//    gchar *defaultplace;     /**< Default command.... Use %s to specify URL. This 
//                                command is called in the background. */
//    gchar *existingwin;
//    gchar *existingwinremote;
//    gchar *newwin;
//    gchar *newwinremote;
//    gchar *newtab;
//    gchar *newtabremote;
//};
/*
struct browser browsers[] = {
    {"gnome", "Gnome Default Browser", "gnome-open %s", NULL, NULL,
     NULL, NULL,
     NULL, NULL},
    {"mozilla", "Mozilla", "mozilla %s",
     NULL, "mozilla -remote openURL(%s)",
     NULL, "mozillax -remote 'openURL(%s,new-window)'",
     NULL, "mozilla -remote 'openURL(%s,new-tab)'"},
    {"firefox", "Firefox", "firefox \"%s\"",
     NULL, "firefox -a firefox -remote \"openURL(%s)\"",
     NULL, "firefox -a firefox -remote 'openURL(%s,new-window)'",
     NULL, "firefox -a firefox -remote 'openURL(%s,new-tab)'"},
    {"netscape", "Netscape", "netscape \"%s\"",
     NULL, "netscape -remote \"openURL(%s)\"",
     NULL, "netscape -remote \"openURL(%s,new-window)\"",
     NULL, NULL},
    {"opera", "Opera", "opera \"%s\"",
     "opera \"%s\"", "opera -remote \"openURL(%s)\"",
     "opera -newwindow \"%s\"", NULL,
     "opera -newpage \"%s\"", NULL},
    {"konqueror", "Konqueror", "kfmclient openURL \"%s\"",
     NULL, NULL,
     NULL, NULL,
     NULL, NULL},
    {NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL}
};
*/

/************************************************************************/
/*                        PUBLIC FUNCTIONS                              */
/************************************************************************/
/*tvh: liferea-specific
*/
/*
gchar *prefs_get_browser_remotecmd()
{
    gchar *ret = NULL;
    gchar *libname = NULL;
    gint place = getNumericConfValue(BROWSER_PLACE);

    libname = getStringConfValue(BROWSER_ID);
    if (!strcmp(libname, "manual")) {
	ret = NULL;
    } else {
	struct browser *iter;
	for (iter = browsers; iter->id != NULL; iter++) {
	    if (!strcmp(libname, iter->id)) {

		switch (place) {
		case 1:
		    ret = g_strdup(iter->existingwinremote);
		    break;
		case 2:
		    ret = g_strdup(iter->newwinremote);
		    break;
		case 3:
		    ret = g_strdup(iter->newtabremote);
		    break;
		}
	    }
	}
    }
    g_free(libname);
    return ret;
}
*/

/*tvh: used by ui_htmlview_launch_in_external_browser
which is not used in RSS feed reader 
*/
/*
gchar *prefs_get_browser_cmd()
{
    gchar *ret = NULL;
    gchar *libname = NULL;
    gint place = getNumericConfValue(BROWSER_PLACE);

    libname = getStringConfValue(BROWSER_ID);
    if (!strcmp(libname, "manual")) {
    //tvh: meam leak 
	//ret = g_strdup(getStringConfValue(BROWSER_COMMAND));
    ret = getStringConfValue(BROWSER_COMMAND);
    } else {
	struct browser *iter;
	for (iter = browsers; iter->id != NULL; iter++) {
	    if (!strcmp(libname, iter->id)) {

		switch (place) {
		case 1:
		    ret = g_strdup(iter->existingwin);
		    break;
		case 2:
		    ret = g_strdup(iter->newwin);
		    break;
		case 3:
		    ret = g_strdup(iter->newtab);
		    break;
		}
		if (ret == NULL)	 //Default when no special mode defined 
		    ret = g_strdup(iter->defaultplace);
	    }
	}
    }
    g_free(libname);
    if (ret == NULL)
	ret = g_strdup(browsers[0].defaultplace);
    return ret;
}

*/
/*------------------------------------------------------------------------------*/
/* preferences dialog callbacks 						*/
/*------------------------------------------------------------------------------*/

void on_prefbtn_clicked(GtkButton * button, gpointer user_data)
{
    g_assert(app_data);
    g_assert(app_data->app_ui_data);
    
    execute_rss_settings(app_data->osso, app_data->app_ui_data->app, TRUE);
}

