/*
   This file is based on unfinished/experimental/abandoned sources from
   Liferea CVS. The original copyright notice is reproduced here:


   fallback HTML display module, which displays the item view
   contents in a text widget
   
   Copyright (C) 2004 Lars Lindner <lars.lindner@gmx.net>  

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef TEXTVIEW_H
#define TEXTVIEW_H

#define FONT_SIZE 14
#define DEFAULT_FONT_SIZE 17

/**
 * Creates a TextView contained inside a ScrollPane for scrolling.
 *
 * @return ScrollPane containing the TextView for displaying feed items.
 */
GtkWidget *gtktextview_new();

/** function to write HTML source given as a UTF-8 string 
  * @param widget
  * @param string
  * @param base
  */
void write_html(GtkWidget * widget, const gchar * string,
		const gchar * base, nodePtr node);

/** Get buffer for textview
  *
  * @return the buffer */
GtkWidget *textview_get_buffer();

/** Tests if launch inside is possible
  * @return result of the test
  */

gboolean launch_inside_possible(void);

/** Function scrolls down the item views scrolled window.
  * @param scrollpane
  * @return FALSE if the scrolled window
  * vertical scroll position is at the maximum and TRUE
  * if the vertical adjustment was increased.
  */
gboolean gtktextview_scroll_pagedown(GtkWidget * scrollpane);

/** launches the specified URL 
  * @param widget
  * @param url to launch
  */
void launch_url(GtkWidget * widget, const gchar * url);

/** Renders item in the textview
  * @param item to render
  */
void textview_render_item(itemPtr ip);

/** Renders an empty feed
  */
void textview_render_empty_feed();

/** Sets the vertical scroll position of the scrolled window
  *
  * @param position the vertical scroll position of the window
  * @return always FALSE
  */
gboolean textview_set_vertical_scroll_position();

/** Gets the vertical scroll position of the scrolled window
  *
  * @return the vertical scroll position as an integer 
  */
int textview_get_vertical_scroll_position();

#endif
