/*
   This file is based on unfinished/experimental/abandoned sources from
   Liferea CVS. The original copyright notice is reproduced here:


   fallback HTML display module, which displays the item view
   contents in a text widget

   Copyright (C) 2004 Lars Lindner <lars.lindner@gmx.net>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* Functions are ordered as in the htmlpluginfo struct */

#include <hildon-widgets/hildon-defines.h>
#include <osso-log.h>
/* TODO: remove those libxml ?? or any other? */
#include <libxml/xmlerror.h>
#include <libxml/uri.h>
#include <libxml/parser.h>
#include <libxml/HTMLparser.h>

#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <errno.h>
#include <time.h>
#include "../common.h"
#include "../htmlview.h"
#include "../support.h"
#include "../callbacks.h"
#include "../update.h"
#include "../debug.h"
#include "../dbus.h"
#include "../appdata.h"
#include "../ui_itemlist.h"



#define FONT_SIZE 14
#define DEFAULT_FONT_SIZE 17
#define FOCUS_BORDER_X 20
#define FOCUS_BORDER_Y 0


//GtkWidget * gtkhtml_htmlview; //the scroll pane
//gchar * rendered_content; //to be used externally
void gtkhtml_init();

void gtkhtml_deinit();
GtkWidget *gtkhtml_new();
void gtkhtml_write_html(GtkWidget * widget, const gchar * string, gchar * base, nodePtr node);
void gtkhtml_stop();
//void gtkhtml_launch_url(GtkWidget * widget, const gchar * url);
//gboolean gtkhtml_launch_inside_possible(void);
/* separate func for search feed */
void gtkhtml_start_write_search_feed(nodePtr node);
void gtkhtml_finish_search_feed(void);


void gtkhtml_zoom_in();
void gtkhtml_zoom_out();

void gtkhtml_block_tap_and_hold_signal(void);
void gtkhtml_unblock_tap_and_hold_signal(void);

gfloat gtkhtml_get_zoom_level(GtkWidget * scrollpane);
void gtk_html_change_the_zoom_level(GtkWidget * scrollpane, gfloat level);
gboolean gtkhtml_scroll_pagedown(GtkWidget * scrollpane);
gboolean gtkhtml_scroll_to_item(nodePtr ptr, guint32 nr);
gboolean gtkhtml_jump_to_next_focusable_object (gboolean jump_down);
gchar * gtkhtml_render_empty_feed(void);
/**Note: This func is supposed to be used by any feed
 * only needed for search feed, as normal feeds 
 * can be done using gtkhtml stream 
*/
void gtkhtml_searchview_append_item (itemPtr ip); 
gchar * gtkhtml_render_head(feedPtr fd);

void gtkhtml_append_and_display_item(itemPtr ip);
void gtkhtml_display_empty_feed(feedPtr fp);

//menu_edit

gboolean htmlwidget_has_selection( GtkWidget *scrollpane );
void htmlwidget_copy_selection( GtkWidget * scrollpane );

gboolean gtkhtml_find_cb( GtkWidget *scrollpane,
                       const gchar *str, 
                       gboolean rewind, 
                       gboolean *retval_ref );

void post_url (const gchar *url, gboolean bluetooth) ;
gchar *strip_url (const gchar *url);
void invoke_url (const gchar *url);

void gtkhtml_grab_cond_focus(gboolean forward);

void gtkhtml_load_images(gboolean load);

void write_image(gpointer pstream, gpointer data, size_t size);

void gtkhtml_selectall();
