/**
 * Copyright (c) 2005-06 Nokia Corporation. All rights reserved.
 * Contact: Ouyang Qi <qi.ouyang@nokia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Initial developer(s): Pinter Sandor, Zsolt Simon
 */

#include <glib.h>




struct enclosure_attribute {
  gchar *ul;
  gchar *type;
  gint length;
};


gchar *enclosure_get_url(struct enclosure_attribute *attrib);
  
/** 
 * Return the type of an enclosure item
 * @param attrib an enclosure item
 * @return the tyep
 */
gchar *enclosure_get_type(struct enclosure_attribute *attrib);

/** 
 * Return the length of an enclosure item
 * @param attrib an enclosure item
 * @return the length
 */
gint enclosure_get_length(struct enclosure_attribute *attrib);
  
/** 
 * Duplicates an atribute structure
 * @param attrib an enclosure item
 * @return the length
 */
struct enclosure_attribute *enclosure_dup_enclosure(struct enclosure_attribute *attrib);

/** 
 * Frees an atribute structure
 * @param attrib an enclosure item
 * @return the length
 */
struct enclosure_attribute *enclosure_free_enclosure(struct enclosure_attribute *attrib);

/** 
 * Sets the type of an enclosure
 * @param attrib an enclosure item
 * @param url the type of the enclosure
 */
void enclosure_set_url(struct enclosure_attribute *attrib,const gchar *url);

/** 
 * Sets the type of an enclosure
 * @param attrib an enclosure item
 * @param type the type of the enclosure
 */
void enclosure_set_type(struct enclosure_attribute *attrib,const gchar *type);

/** 
 * Sets the length of an enclosure
 * @param attrib an enclosure item
 * @param length the length of the enclosure
 */
void enclosure_set_length(struct enclosure_attribute *attrib,const gint length);
