/**
    @file dbus.h

    Copyright (c) 2004-2006 Nokia Corporation. All rights reserved.
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/


#ifndef RSS_DBUS_H
#define RSS_DBUS_H

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif				/* HAVE_CONFIG_H */

#include <gtk/gtk.h>
#include <glib/gstdio.h>
#include <hildon-widgets/gtk-infoprint.h>

#define DBUS_API_SUBJECT_TO_CHANGE

#define CALLBACK_SIZE 4

#if 1 // From osso email 0.5.7 src/ui/inc/ui_interface.h (not yet in system headers)
# define _DBUS_POINTER_SHIFT(p)   ((void*) (((char*)p) + sizeof (void*)))
# define DBUS_G_CONNECTION_FROM_CONNECTION(x)     ((DBusGConnection*) _DBUS_POINTER_SHIFT(x))
#endif

#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>

#include <libosso.h>
#include <osso-browser-interface.h>

#include <libosso.h>
#include <glib.h>
#include <osso-log.h>

#include "appdata.h"

/* RSS Feed Reader definitions */

#define OSSO_RSS_FEED_READER_SERVICE "com.nokia.osso_rss_feed_reader"
#define OSSO_RSS_FEED_READER_INTERFACE "com.nokia.osso_rss_feed_reader"
#define OSSO_RSS_FEED_READER_OBJECT_PATH "/com/nokia/osso/rss_feed_reader"

/* Define d-bus messages, to which application have to react */

#define OSSO_RSS_FEED_READER_REFRESH_SIGNAL "refresh"
#define OSSO_RSS_FEED_READER_DISPLAY_SIGNAL "display"
/*tvh: This will be used by osso_mime_open_*() to add a file ending with 
 .xml,.rss .atom or such as a feed
 or .opml file as a directory feed */
#define OSSO_RSS_FEED_READER_ADD_SIGNAL "mime_open"

#define OSSO_RSS_FEED_READER_REFRESH_FINISHED_SIGNAL "refresh_finished"
#define OSSO_RSS_FEED_READER_REFRESH_PREVENTED_SIGNAL "refresh_prevented"
#define OSSO_RSS_FEED_READER_REFRESH_INTERRUPTED_SIGNAL "refresh_interrupted"
#define OSSO_RSS_FEED_READER_FOLDER_READ_SIGNAL "folder_read"
#define OSSO_RSS_FEED_READER_REFRESH_STARTED "refresh_started"
#define OSSO_RSS_FEED_READER_CONNECTING_STARTED "connecting_started"

/** 
 Receive D-BUS messages and handles them

 @param interface The interface of the called method.
 @param method The method that was called.
 @param arguments A GArray of osso_rpc_t_structures.
 @param data An application specific pointer.
 @param retval The return value of the method.
 @returns gint value
 */

gint dbus_req_handler(const gchar * interface,
		      const gchar * method,
		      GArray * arguments,
		      gpointer app_data, osso_rpc_t * retval);


/** Handles incoming D-BUS message

 @param method The method that was called.
 @param arguments A GArray of osso_rpc_t structures.
 @param data An application specific pointer.
 @param retval The return value of the method.
 @returns gint value
 */
gint dbus_message_handler(const gchar * method,
			  GArray * arguments,
			  gpointer app_data, osso_rpc_t * retval);


/**
 Set hardware event handler

 @param state Signals that are of interest
 @param cb Callback function.
 @param data Application specific data.
 */

gboolean set_hw_event_handler(osso_hw_state_t * state,
			      osso_hw_cb_f * cb, gpointer data);

/** 
 Handles hardware events.

 @todo Just a skeleton
 @param state State occured.
 @param data Application specific data.
 */

void hw_event_handler(osso_hw_state_t * state, gpointer data);

/**
 Initialize osso

 @param app Application specific data
 @returns TRUE on success, FALSE otherwise
 */

gboolean init_osso(AppData * app_data);

/**
 Deinitialize osso

 @returns TRUE on success, FALSE otherwise
 */
gboolean deinit_osso();

/**
 Open link in web browser.
  
 @returns TRUE on success, FALSE otherwise
 */
gboolean open_url(gchar * url);

/**
 Send a D-BUS signal that refresh has completed.

 @returns TRUE on success, FALSE otherwise
 */
gboolean rss_dbus_refresh_completed();

/**
 Send a D-BUS signal to the RSS applet.

 @param signal signal to send
 @returns TRUE on success, FALSE otherwise
 */
gboolean rss_dbus_signal_applet(gchar * signal);

void bt_send(const gchar *title, gpointer data, size_t size);

gboolean bt_avail();

gboolean request_iap_connect();

void find_iap_connection_type();

gboolean request_iap_disconnect();

void deinit_osso_callback();

#endif
