/**
    @file dbus.c

    Copyright (c) 2004-2006 Nokia Corporation. All rights reserved.
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <conbtdialogs-dbus.h>
#include <conic.h>

//#include <osso-ic-dbus.h>

#include <settings.h>

#include "dbus.h"
#include "conf.h"
#include "debug.h"

#include "callbacks.h"
#include "ui_feedlist.h"
#include "update.h"
#include "support.h"
#include "main.h"
#include "callbacks.h"
#include "ui_feed_directory.h"
#include "gtkhtml/gtkhtml_plugin.h"

#ifdef UPDATE_DEBUG_MUTEX
#define G_MUTEX_LOCK(mx) { ULOG_DEBUG("##Trying to lock mutex: %s, %d, %p", __FUNCTION__, __LINE__, g_thread_self()); g_mutex_lock(mx); ULOG_DEBUG("##Locked mutex: %s, %d, %p", __FUNCTION__, __LINE__, g_thread_self()); }
#define G_MUTEX_UNLOCK(mx) { ULOG_DEBUG("##Trying to unlock mutex: %s, %d, %p", __FUNCTION__, __LINE__, g_thread_self()); g_mutex_unlock(mx); ULOG_DEBUG("##Unlocked mutex: %s, %d, %p", __FUNCTION__, __LINE__, g_thread_self()); }
#define GDK_THREADS_ENTERD { ULOG_DEBUG("@@Trying gdk_threads_enter: %s, %d, %p", __FUNCTION__, __LINE__, g_thread_self()); if (g_thread_self() != mainThread) gdk_threads_enter(); ULOG_DEBUG("@@Success gdk_threads_enter: %s, %d, %p", __FUNCTION__, __LINE__, g_thread_self()); }
#define GDK_THREADS_LEAVED { ULOG_DEBUG("@@Trying gdk_threads_leave: %s, %d, %p", __FUNCTION__, __LINE__, g_thread_self()); if (g_thread_self() != mainThread) gdk_threads_leave(); ULOG_DEBUG("@@Success gdk_threads_leave: %s, %d, %p", __FUNCTION__, __LINE__, g_thread_self()); }
#else
#define G_MUTEX_LOCK(mx) g_mutex_lock(mx);
#define G_MUTEX_UNLOCK(mx) g_mutex_unlock(mx);
#define GDK_THREADS_ENTERD { if (g_thread_self() != mainThread) gdk_threads_enter(); }
#define GDK_THREADS_LEAVED { if (g_thread_self() != mainThread) gdk_threads_leave(); }
#endif

extern AppData *app_data;
extern time_t rss_updated;
extern feedPtr searchFeed;
extern GThread *mainThread;

inline void free_iap_type();

/************************************************************************/
/*                        PRIVATE FUNCTIONS                             */
/************************************************************************/

static ConIcConnection *iap = NULL;
static DBusGConnection *connection = NULL;
static DBusGProxy *proxy = NULL;
static GTimer *messageTimer = NULL;

static void ui_show_lowmem_banner(void)
{
    gtk_infoprint( GTK_WINDOW(app_data->app_ui_data->app), 
                    dgettext("ke-recv", "memr_ib_operation_disabled") );
    return;                    
    /*
  GtkWidget * note =  hildon_note_new_information(GTK_WINDOW(app_data->app_ui_data->app),
        dgettext("ke-recv", "memr_ib_operation_disabled") );
  //hildon_note_set_button_text(note, __("sfil_ni_not_enough_memory_ok"));

  gtk_dialog_run(GTK_DIALOG(note));
  gtk_widget_destroy(GTK_WIDGET(note));

  //hildon_appview_set_title(app_data->app_ui_data->app, "");
  //plugin_settings_set_string(SETTINGS_CHESS_SAVE_FILE,"");
    */
}


static DBusHandlerResult file_sent_signal ( DBusConnection *connection,
                                            DBusMessage *message,
                                            void *data )
{
    gboolean success = FALSE;

    /* check signal */
    if (!dbus_message_is_signal(message,
                                CONBTDIALOGS_DBUS_INTERFACE,
                                CONBTDIALOGS_SEND_FILE_SIG))
        return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;

    /* get args */
    if ( !dbus_message_get_args ( message, NULL,
                                  DBUS_TYPE_BOOLEAN, &success,
                                  DBUS_TYPE_INVALID ) )
      return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;

    gchar *p;
    if ((p = app_data->app_ui_data->bt_file))
    {
        ULOG_DEBUG("Deleting temporary file used for bluetooth: %s", p); 

        g_unlink(p);
        app_data->app_ui_data->bt_file = NULL;
        g_free(p);
    }
        
    if (success) 
        ULOG_DEBUG("File sent successfully"); 
    else 
        ULOG_DEBUG("Failure sending file\n");

    return DBUS_HANDLER_RESULT_HANDLED;
}

static void handle_iap_connected (AppUIData *app_ui_data, gchar *bearer)
{
    ULOG_INFO("OSSO_IAP_CONNECTED");
    ULOG_DEBUG("iap action: %d",app_ui_data->iap_action);
    
    download_set_online(TRUE);
    /* Lets refresh all the feeds without popping up the refresh dialog.
    The applet uses this */
    /*else*/
    
    gint iap_action = app_ui_data->iap_action;
    app_ui_data->iap_action = OSSO_IAP_NO_ACTION;
    
    if (iap_action == OSSO_IAP_REFRESH_NO_DIALOG)
    {
        if (SFM_NORMAL == app_ui_data->search_mode ||
            SFM_CONNECTING == app_ui_data->search_mode) 
        {
            gint type = getNumericConfValue(RSS_SETTINGS_AUTOMATIC_UPDATES_TYPE);

            ULOG_DEBUG("Autoupdate: type=%d, bearer=%s", type, bearer);

            if ((type == 0 && strncasecmp(bearer, "WLAN", 4) == 0) ||
                    (type == 1))
                ui_feedlist_do_for_all(NULL, ACTION_FILTER_FEED,
                        on_refreshbtn_clicked_cb);

/*            if (!get_counter(C_RSS_MAX) && 
                    app_data->app_ui_data->start_on_background)
                on_quit(FALSE);*/
        }
    }
    /* If no feed has been selected all feeds are refreshed */
    else if (iap_action == OSSO_IAP_REFRESH_ALL_NO_DIALOG)
    {
        if (SFM_NORMAL == app_ui_data->search_mode ||
            SFM_CONNECTING == app_ui_data->search_mode) {
            ULOG_DEBUG("Refresh without dialog");

            if (app_ui_data->manage_folders_displayed)
            {
			  gtk_widget_set_sensitive(lookup_widget(app_ui_data->dialog, "mf_deletebtn"), FALSE);
              gtk_widget_set_sensitive(lookup_widget(app_ui_data->dialog, "mf_renamebtn"), FALSE);
		    }
				
            ui_feedlist_do_for_all(NULL, ACTION_FILTER_FEED,
                    on_refreshbtn_clicked_cb);
        }
    }
    /* Refresh a single feed */
    else if (iap_action == OSSO_IAP_REFRESH_FEED)
    {
         ULOG_DEBUG("OSSO_IAP_REFRESH_FEED");

         feed_schedule_update(app_data->app_ui_data->new_subscription,
             app_data->app_ui_data->new_subscription_flags | FEED_REQ_PRIORITY_HIGH |
             FEED_REQ_DOWNLOAD_FAVICON | FEED_REQ_AUTH_DIALOG );

         app_ui_data->new_subscription = NULL;
         app_ui_data->new_subscription_flags = 0;
    }
    /* Refresh the feed directory contents */
    else if (iap_action == OSSO_IAP_REFRESH_FEED_DIRECTORY)
    {
        ULOG_DEBUG("Refresh feed directory contents");

        ui_feed_directory_get();
    }  
    else if (iap_action == OSSO_IAP_NEW_SUBSCRIPTION)
    {
        feedPtr fp = NULL;
        gchar *tmp = NULL;
        
        ULOG_DEBUG("OSSO_IAP_NEW_SUBSCRIPTION");
                            
        /* Only take action is the add feed dialog is open */
        if(app_ui_data->add_feed_dialog != NULL) 
        {
            fp = feed_new();
            tmp = conf_new_id();
            feed_set_id(fp, tmp);
            g_free(tmp);
        
            feed_set_source(fp, app_ui_data->source);
            feed_set_title(fp, app_ui_data->source);
            feed_set_filter(fp, app_ui_data->filter);
            feed_set_added(fp, time(NULL));
            feed_set_new_subscription(fp, TRUE);

            ui_search_clear_search_results();

            if(displayed_node == (nodePtr)searchFeed)
            { 
                ULOG_DEBUG("dbus: handle iap connected");
                ui_mainwindow_show_statistics();
            }
            
            feed_schedule_update(fp,
                 app_data->app_ui_data->new_subscription_flags | FEED_REQ_PRIORITY_HIGH |
                 FEED_REQ_DOWNLOAD_FAVICON | FEED_REQ_AUTH_DIALOG );

            g_free(app_ui_data->source);
            g_free((gchar *)app_ui_data->filter);

            app_ui_data->source = NULL;
            app_ui_data->filter = NULL;
            app_ui_data->new_subscription_flags = 0;
        
            /*	    
            gtk_widget_set_sensitive(app_data->app_ui_data->newfeedbtn, FALSE);
            gtk_widget_set_sensitive(app_data->app_ui_data->changefolderbtn, FALSE);
            */
    //              gtk_widget_set_sensitive(app_data->app_ui_data->cancelbtn, FALSE);
        }
    }
    /*tvh: Added this handler */
    else if (iap_action == OSSO_IAP_DOWNLOAD_IMAGES_FOR_DISPLAY)
    {
        ULOG_DEBUG("handle_iap_connect: OSSO_IAP_DOWNLOAD_IMAGES_FOR_DISPLAY");
/*        gtkhtml_handle_net_connect(app_ui_data->img_req_list);*/
    }
    /* Take no refreshing action */
    else if (iap_action == OSSO_IAP_NO_ACTION)
    {
        ULOG_DEBUG("IAP no action");
    } else if (iap_action == OSSO_IAP_REFRESH_LIST)
    {
      while (app_ui_data->list_for_update)
      {
        feed_schedule_update(app_ui_data->list_for_update->data,
			         app_ui_data->flags_for_list);
        app_ui_data->list_for_update=g_slist_remove(app_ui_data->list_for_update,app_ui_data->list_for_update->data);
      }
      app_ui_data->connect_at_the_end=FALSE;
      app_ui_data->flags_for_list=0;
    }
}

static void handle_iap_disconnected (AppUIData *app_ui_data)
{
    g_assert(app_ui_data != NULL);

    ULOG_DEBUG("\n\n\n>>>>>>>> Disconnect detected <<<<<<<<<<<\n\n\n");
    /* A new subscription was made without an existing connection
       and the user hit cancel in the connection dialog */    
    if (app_ui_data->iap_action == OSSO_IAP_NEW_SUBSCRIPTION)    
    {
        const gchar *source = NULL;
        const gchar *filter = NULL;
        gint flags = 0;
        folderPtr selected_parent = NULL;

        ULOG_DEBUG("Adding a feed without a connection");
        source = app_ui_data->source;
        filter = app_ui_data->filter;
        flags = app_ui_data->new_subscription_flags;
        selected_parent = app_ui_data->ui_data->parent_folder;

        /* Search must be cleared before adding new stuff to the tree */	
        /* TODO: SZs. TH comment */
        //ui_search_clear_search_results();

        if(displayed_node == (nodePtr)searchFeed)
        {
            ULOG_DEBUG("dbus: handle_iap_error");
            ui_mainwindow_show_statistics();
        }

        ULOG_DEBUG("Adding: %s", source);
        ui_feedlist_new_subscription_for_fd(source, filter, flags, selected_parent, FALSE, TRUE);
        
        g_free(app_ui_data->source);
        g_free((gchar *)app_ui_data->filter);

        app_ui_data->source = NULL;
        app_ui_data->filter = NULL;
        app_ui_data->new_subscription_flags = 0;
        
        newdialog_destroy();
    }
    
    gint old_mode = app_ui_data->search_mode;
    if (old_mode == SFM_REFRESH ||
        old_mode == SFM_CONNECTING) {

        ULOG_DEBUG("@@@ Cancelling all data: %d", old_mode);
        app_ui_data->search_mode = SFM_INTERRUPTED;
        download_cancel_all(FALSE);

        if (!app_data->app_ui_data->start_on_background &&
                old_mode != SFM_CONNECTING)
            gtk_infoprint(GTK_WINDOW(app_data->app_ui_data->app), 
                _("rss_ni_connection_was_lost"));
    }
    app_ui_data->iap_action = OSSO_IAP_NO_ACTION;
    download_set_online(FALSE);
}

static void connection_cb(ConIcConnection *connection,
                          ConIcConnectionEvent *event,
                          gpointer user_data)
{
    ULOG_DEBUG("connection_cb(%p, %p, %p)", connection, event, user_data);

    const gchar *iap_id, *bearer;
    ConIcConnectionStatus status;
    ConIcConnectionError error;
    AppUIData *app_ui_data = (AppUIData *)user_data;

    g_assert(CON_IC_IS_CONNECTION_EVENT(event));

    status = con_ic_connection_event_get_status(event);
    error = con_ic_connection_event_get_error(event);
    iap_id = con_ic_event_get_iap_id(CON_IC_EVENT(event));
    bearer = con_ic_event_get_bearer_type(CON_IC_EVENT(event));


    GDK_THREADS_ENTERD;
//   gdk_threads_enter();

    free_iap_type();

    switch (status) {
    case CON_IC_STATUS_CONNECTED:
        ULOG_DEBUG("CONNECTED (%s, %s, %i, %i)",
                iap_id, bearer, status, error);
        app_data->app_ui_data->network_iap = g_strdup(iap_id);
        handle_iap_connected(app_ui_data, bearer);
        break;
    case CON_IC_STATUS_DISCONNECTED:
        ULOG_DEBUG("DISCONNECTED (%s, %s, %i, %i)",
                iap_id, bearer, status, error);
        handle_iap_disconnected(app_ui_data);
        break;
    case CON_IC_STATUS_DISCONNECTING:
        ULOG_DEBUG("DISCONNECTING (%s, %s, %i, %i)",
                iap_id, bearer, status, error);
        handle_iap_disconnected(app_ui_data);
        break;
    default:
        break;
    }

    if (app_data->app_ui_data->progressbar_mode == PROGRESSBAR_CONNECT_MODE)
    {
        switch_progressbar(PROGRESSBAR_NORMAL_MODE);
    }
    GDK_THREADS_LEAVED;
}


/************************************************************************/
/*                        PUBLIC FUNCTIONS                              */
/************************************************************************/

gboolean request_iap_connect()
{
    gboolean result = FALSE;

    ULOG_DEBUG("Requesting new connection.... %d", app_data->app_ui_data->iap_action);
    if (app_data->app_ui_data->iap_action == OSSO_IAP_NEW_SUBSCRIPTION &&
        app_data->app_ui_data->source &&
        strncasecmp(app_data->app_ui_data->source, "file://", 7) == 0)
    {
        ULOG_DEBUG("Skipping connecting for local file ...");
        handle_iap_connected(app_data->app_ui_data, "");
        return TRUE;
    }

    if (app_data->app_ui_data->iap_action == OSSO_IAP_NEW_SUBSCRIPTION &&
        app_data->app_ui_data->source &&
        strncasecmp(app_data->app_ui_data->source, "obex://", 7) == 0)
    {
        ULOG_DEBUG("Skipping connecting for file on gateway...");
        handle_iap_connected(app_data->app_ui_data, "");
        return TRUE;
    }
    
    if (iap) {
        switch_progressbar(PROGRESSBAR_CONNECT_MODE);
//        show_stop_refresh_button(TRUE);
        result = con_ic_connection_connect(iap, CON_IC_CONNECT_FLAG_NONE);
    }
    
    return result;
}

/* TODO: Remove function as it is unused. (commented out in one place 
 * in request_iap_disconnect). Remove?
static gboolean dbus_mcall_send (DBusMessage *mcall)
{
    DBusPendingCall *pending_call = NULL;

    g_return_val_if_fail (mcall != NULL, FALSE);

    ULOG_DEBUG("dbus_mcall_send: start");
    DBusConnection *connection = dbus_bus_get(DBUS_BUS_SYSTEM, NULL);
    g_return_val_if_fail (connection != NULL, FALSE);

    if ( dbus_message_get_type ( mcall ) != DBUS_MESSAGE_TYPE_METHOD_CALL )
    {
        dbus_connection_unref(connection);
        return FALSE;
    }

    dbus_message_set_no_reply ( mcall, TRUE );

    ULOG_DEBUG("dbus_mcall_send: before send");
    if (!dbus_connection_send_with_reply (connection, mcall, &pending_call, -1))
    {
        ULOG_DEBUG("dbus_mcall_send: end01");
        dbus_connection_unref(connection);
        ULOG_DEBUG("dbus_mcall_send: end1");
        return FALSE;
    }
    ULOG_DEBUG("dbus_mcall_send: end02");
    dbus_pending_call_unref (pending_call);

    dbus_connection_unref(connection);

    ULOG_DEBUG("dbus_mcall_send: end2");
    return TRUE;
}
*/

gboolean request_iap_disconnect()
{
    gboolean result = FALSE;
    
    ULOG_DEBUG("request_iap_disconnect");
    if (iap) {
        handle_iap_disconnected(app_data->app_ui_data);
    }
    
    return result;
}

/* Define topping */
osso_application_top_cb_f *osso_top_callback(const gchar * arguments,
					     AppData * app_data)
{
    g_assert(app_data);
    g_assert(app_data->app_ui_data != NULL);
    
    gtk_widget_show(GTK_WIDGET(app_data->app_ui_data->app));
    gtk_window_present(GTK_WINDOW(app_data->app_ui_data->app));
    return NULL;
}

gint dbus_req_handler(const gchar * interface,
		      const gchar * method,
		      GArray * arguments,
		      gpointer data, osso_rpc_t * retval)
{
    (void) interface;
    return dbus_message_handler(method, arguments, data, retval);
}

gint dbus_message_handler(const gchar * method,
			  GArray * arguments,
			  gpointer data, osso_rpc_t * retval)
{
    AppData *app_data = NULL;
    app_data = (AppData *) data;
    AppUIData *app_ui_data;
    gchar *filename = NULL;
    gchar *feed = NULL;
    guint32 nr = 0;

    g_assert(app_data != NULL);
    g_assert(app_data->app_ui_data != NULL);
        
    app_ui_data = app_data->app_ui_data;
    ULOG_DEBUG("%s received call for method %s", __FUNCTION__, method);

    (void) arguments;
    g_assert(method);

    if (g_ascii_strcasecmp(method, "top_application") == 0) {
	printf("==================================\n");
	printf("=           TOP APPLICATION      =\n");
	printf("==================================\n");
        app_ui_data->start_on_background = FALSE;

        GDK_THREADS_ENTERD;
//        gdk_threads_enter();
        abort_quit();
        gtk_widget_show(GTK_WIDGET(app_data->app_ui_data->app));
        gtk_window_present(GTK_WINDOW(app_data->app_ui_data->app));
        GDK_THREADS_LEAVED;
//        gdk_threads_leave();
        
        retval->type = DBUS_TYPE_INVALID;
        osso_rpc_free_val (retval);
        return OSSO_OK;
    }
    else
    /* Catch the message and define what you want to do with it */
    if (g_ascii_strcasecmp(method, OSSO_RSS_FEED_READER_REFRESH_SIGNAL) ==
	0) {
	
        //Try to avoid several messages in a short time
        if (g_timer_elapsed(messageTimer, NULL) > 0.2) {
            filename =
                g_strdup_printf("%s" G_DIR_SEPARATOR_S ".osso_rss_feed_reader"
                    G_DIR_SEPARATOR_S "background",
                    g_get_home_dir());

            if (g_file_test(filename, G_FILE_TEST_EXISTS)) {
                g_unlink(filename);
            }
            g_free(filename);	

            gboolean timed = g_array_index(arguments, osso_rpc_t, 0).value.b;
           
            if(timed && !app_ui_data->start_on_background)
            {
                g_timer_reset(messageTimer);
                retval->type = DBUS_TYPE_INVALID;
                osso_rpc_free_val (retval);
                return OSSO_OK;
            }
           
            if (app_ui_data->search_mode != SFM_NORMAL) {
                if (app_ui_data->search_mode == SFM_REFRESH) {
                    download_cancel_all(FALSE);
                    // 		on_refresh_finished(FALSE, FALSE);
                } else
                    rss_dbus_signal_applet
                        (OSSO_RSS_FEED_READER_REFRESH_PREVENTED_SIGNAL);

                g_timer_reset(messageTimer);
                retval->type = DBUS_TYPE_INVALID;
                osso_rpc_free_val (retval);
                return OSSO_OK;
            }

            GDK_THREADS_ENTERD;
//            gdk_threads_enter();
            app_ui_data->iap_action = OSSO_IAP_REFRESH_ALL_NO_DIALOG;
        /*	   osso_iap_connect(OSSO_IAP_ANY,
                 timed ? OSSO_IAP_TIMED_CONNECT :
                 OSSO_IAP_REQUESTED_CONNECT, app_ui_data);*/
            request_iap_connect();
//            gdk_threads_leave();
            GDK_THREADS_LEAVED;
        }

        g_timer_reset(messageTimer);
        retval->type = DBUS_TYPE_INVALID;
        osso_rpc_free_val (retval);
        return OSSO_OK;
    } else
	if (g_ascii_strcasecmp(method, OSSO_RSS_FEED_READER_DISPLAY_SIGNAL)
	    == 0) {
        GDK_THREADS_ENTERD;
//        gdk_threads_enter();
        filename =
	    g_strdup_printf("%s" G_DIR_SEPARATOR_S ".osso_rss_feed_reader"
			G_DIR_SEPARATOR_S "headline_clicked", g_get_home_dir());
        if (g_file_test(filename, G_FILE_TEST_EXISTS)) {
	       g_unlink(filename);
        }
        g_free(filename);    
	    
	    feed = (gchar *) g_array_index(arguments, osso_rpc_t, 0).value.s;
	    nr = g_array_index(arguments, osso_rpc_t, 1).value.u;
	   
        ULOG_DEBUG("Headline clicked: %s, %d", feed, nr);
        
	    /* If the news reader is running and is put into the background
	    a state save is made (by calling callbacks.c:on_untop). Now when the 
	    user clicks on a headline  After that, 
	    the application is put to foreground again and the callbacks.c:on_top
	    is called. This restores the saved state and displays the saved feed
	    and the headline that was displayed is gone. For this reason,
	    the state is not loaded when a headline is clicked */
	   
	    reset_state_file(app_data->osso);
	    	
	    ui_feedlist_display_news(feed, nr);
        
        gtk_window_present(GTK_WINDOW(app_ui_data->app));

        retval->type = DBUS_TYPE_INVALID;

        /* TODO: 
        Very hackish. Somehow, applet needs this for ui to be responsive
        in the ui_update in gtkhtml_write while loop
        Something mysterious with the DBus that makes ui_update doesn't work
        even though gtk_main() in main() is already invoked
        */

        //gtk_main();
        //gtk_main_quit();
        GDK_THREADS_LEAVED;
//        gdk_threads_leave();
//         osso_rpc_free_val (retval);
        return OSSO_OK;
    }

    else if (g_ascii_strcasecmp(method, DBUS_NEWS_ALARM_SIGNAL) == 0) {
        ULOG_DEBUG("\n\n\n******It's refresh time*******\n\n\n");
        GDK_THREADS_ENTERD;
//        gdk_threads_enter();
        app_data->app_ui_data->auto_refresh_is_ongoing=TRUE;
        ui_feedlist_auto_update(NULL);
        GDK_THREADS_LEAVED;
//        gdk_threads_leave();
/*        if (!get_counter(C_RSS_MAX) && 
                app_data->app_ui_data->start_on_background)
            on_quit(FALSE);
        else 
            download_set_online(TRUE);*/
        
        retval->type = DBUS_TYPE_INVALID;
        osso_rpc_free_val (retval);
        return OSSO_OK;
    }
    
    else if (g_ascii_strcasecmp(method, OSSO_RSS_FEED_READER_ADD_SIGNAL)
	    == 0) {

        ULOG_DEBUG("dbus msg OSSO_RSS_FEED_READER_ADD_AND_DISPLAY_SIGNAL");
   	    gchar * fd_source = (gchar *) g_array_index(arguments, osso_rpc_t, 0).value.s;

        ULOG_DEBUG("dbus_msg_handler: fd_source = %s", fd_source);

        GDK_THREADS_ENTERD;
//        gdk_threads_enter();
        if (app_data->app_ui_data->feed_directory_dialog)
        {
          gtk_dialog_response(app_data->app_ui_data->feed_directory_dialog,GTK_RESPONSE_CANCEL);
        }
        
        if (app_data->app_ui_data->cfdialog != NULL)
        {
          
          if (app_data->app_ui_data->nfdialog != NULL)
          {
            gtk_widget_destroy(GTK_WIDGET(app_data->app_ui_data->nfdialog));
            app_data->app_ui_data->nfdialog = NULL;
          }
          
          gtk_widget_destroy(GTK_WIDGET(app_data->app_ui_data->cfdialog));
          app_data->app_ui_data->cfdialog = NULL;

        }
        
        if (app_data->app_ui_data->mfdialog != NULL)
        {
          
          if (app_data->app_ui_data->nfdialog != NULL)
          {
            gtk_widget_destroy(GTK_WIDGET(app_data->app_ui_data->nfdialog));
            app_data->app_ui_data->nfdialog = NULL;
          }
          
          app_ui_data->dialog = NULL;
          gtk_widget_destroy(GTK_WIDGET(app_data->app_ui_data->mfdialog));
          app_data->app_ui_data->mfdialog = NULL;
          app_data->app_ui_data->manage_folders_displayed=FALSE;

        }
        
        if (app_data->app_ui_data->propdialog != NULL)
        {
          
          app_ui_data->dlg_btn_unsubscribe = NULL;
          g_free(app_ui_data->ui_data);
          app_ui_data->dialog = NULL;
          gtk_widget_destroy(GTK_WIDGET(app_data->app_ui_data->propdialog));
          app_data->app_ui_data->propdialog = NULL;

        }
        if (app_data->app_ui_data->add_feed_dialog != NULL)
            newdialog_destroy();

        if (app_data->app_ui_data->fsdialog != NULL)
        {
          
          gtk_dialog_response(app_data->app_ui_data->fsdialog,GTK_RESPONSE_CANCEL);
          
        }
        if (app_data->app_ui_data->search_mode<SFM_SEARCH)
        {
        /* Destroy those modal dialogs first */
        if (app_data->app_ui_data->refresh_dialog != NULL)
        {
            gtk_widget_destroy(GTK_WIDGET(app_data->app_ui_data->refresh_dialog));
            app_data->app_ui_data->refresh_dialog = NULL;
            app_data->app_ui_data->dialog = NULL;
        }
        //Suppose it's a feed. Just add it. Might not be a feed though. TODO:
        else 
        {
            gtk_window_present(GTK_WINDOW(app_ui_data->app));
            on_newbtn_clicked(app_data, fd_source);
    
        }
        retval->type = DBUS_TYPE_INVALID;
        osso_rpc_free_val (retval);
        GDK_THREADS_LEAVED;
        return OSSO_OK;
      }
      else
      {
        gtk_window_present(GTK_WINDOW(app_ui_data->app));
        if (app_data->app_ui_data->search_mode==SFM_SEARCH)
        {
          gtk_infoprint(GTK_WINDOW(app_data->app_ui_data->app),
                 _("rss_ib_unable_add_feed_searching"));
        }
        else
        {
          gtk_infoprint(GTK_WINDOW(app_data->app_ui_data->app),
                 _("rss_ib_unable_add_feed"));
        }
        retval->type = DBUS_TYPE_INVALID;
        osso_rpc_free_val (retval);
//        gdk_threads_leave();
        GDK_THREADS_LEAVED;
        return OSSO_OK;
      }
    }
     else {
	   ULOG_WARN("Unknown DBUS method: %s\n", method);
    }
    osso_rpc_free_val (retval);
    return OSSO_ERROR;
}

extern gboolean lifereaStarted;
/* Depending on the state of hw, do something */
void hw_event_handler(osso_hw_state_t * state, gpointer data)
{
    (void) data;

    g_assert(state != NULL);
    
    ULOG_DEBUG("Hardware event received: %d %d %d %d", state->shutdown_ind,
               state->memory_low_ind, state->save_unsaved_data_ind, state->system_inactivity_ind);
    
    if (state->shutdown_ind) {
	/* Rebooting */
	on_quit(FALSE);
    }
    if (state->memory_low_ind) {
    /* Memory low */
       /*If the page is rendering or downloading. We should stop it. If too many images
       for example: alienlovespredator.com/alp_rss.xml. It will crash
       */
       ULOG_DEBUG("*************************************************************************LOW MEMORY SIGNAL caught");
        //this will happen if NR is starting in low mem condition
        if (!lifereaStarted)
        {
            ULOG_DEBUG("News Reader hasn't started. Exiting now");
            exit(0);
        
        }
        app_data->app_ui_data->low_mem = TRUE;
	
        GDK_THREADS_ENTERD;
//        gdk_threads_enter();
        gtkhtml_stop();
	
	if (SFM_SEARCH == app_data->app_ui_data->search_mode) {
    	    download_cancel_all(TRUE);
    	    ULOG_DEBUG("Low memory signal handled");
    	    ui_show_lowmem_banner();
	}
        GDK_THREADS_LEAVED;
//        gdk_threads_leave();    
       
    }
    else 
    {
        app_data->app_ui_data->low_mem = FALSE;    
    }
    if (state->save_unsaved_data_ind) {
	/* Save unsaved data. For this the itemlist must
	   be emptied */
// 	save_state(app_data);
// 	ui_itemlist_search_init();
//         save_application_data();
//         ui_mainwindow_finish();
// 	restore_state(app_data);
//         if(app_data == NULL)
// 	    return;
// 	    
// 	if(app_data->app_ui_data == NULL)
// 	    return;
// 	    
//         if(app_data->app_ui_data->search_mode == SFM_NORMAL)
// 	{
//             conf_feedlist_save();
// 	    ui_feedlist_do_for_all(NULL,
// 			           ACTION_FILTER_FEED | ACTION_FILTER_DIRECTORY,
// 			           feed_save);
// 
//             setBooleanConfValue(LAST_ITEMLIST_MODE, !itemlist_mode);
// 	}    
    }
    if (state->system_inactivity_ind) {
	/* Minimum activity */
    }
}

/* Do initialization, create context, set topping callback,
   dbus-message handling callbaks, and hw-event callbacks. */
gboolean init_osso(AppData * app_data)
{
    osso_return_t ret, ret2;
    GError *error = NULL;

    g_assert(app_data != NULL);
    g_assert(app_data != NULL);
    
    /* gtk_init already started this . Calling this again will cause mem leaks */
    g_type_init();

    ULOG_INFO("Initializing [%s] version [%s]", PACKAGE_NAME,
	      PACKAGE_VERSION);
    app_data->osso =
	osso_initialize(PACKAGE_NAME, PACKAGE_VERSION, TRUE, NULL);

    g_assert(app_data->osso);

    if (app_data->osso == NULL) {
	ULOG_CRIT("Osso initialization failed");
	return FALSE;
    }
    g_assert(app_data->osso);

    messageTimer = g_timer_new();
    /* Set topping callback */
/*    osso_application_set_top_cb(app_data->osso,
				(osso_application_top_cb_f *)
				osso_top_callback, (gpointer) (app_data));*/

    /* Set handling d-bus messages from session bus  */
    ret = osso_rpc_set_cb_f(app_data->osso,
			    OSSO_RSS_FEED_READER_SERVICE,
			    OSSO_RSS_FEED_READER_OBJECT_PATH,
			    OSSO_RSS_FEED_READER_INTERFACE,
			    dbus_req_handler, app_data);

    ret2 = osso_rpc_set_cb_f(app_data->osso,
			DBUS_NEWS_SERVICE_NAME_REFRESH,
			DBUS_NEWS_SERVICE_PATH_REFRESH,
			DBUS_NEWS_INTERFACE_NAME_REFRESH,
			dbus_req_handler, app_data);

    if (ret != OSSO_OK || ret2 != OSSO_OK) {
	ULOG_CRIT("Could not set callback for receiving messages");
    }

    /* Set handling changes in HW states. Note: not tested */
    ret = osso_hw_set_event_cb(app_data->osso,
			       NULL, hw_event_handler, app_data);

    if (ret != OSSO_OK) {
        ULOG_CRIT("Could not set callback for HW monitoring");
    }

    iap = con_ic_connection_new();
    if (!iap) {
        ULOG_CRIT("Could not set callback for connectivity");
        g_assert(!iap);
    }

    g_object_set(iap, "automatic-connection-events", TRUE, NULL);
	
    g_signal_connect(G_OBJECT(iap), "connection-event",
                     G_CALLBACK(connection_cb),
                     app_data->app_ui_data);

    connection = dbus_g_bus_get(DBUS_BUS_SYSTEM, &error);

    if (connection == NULL )
    {
        ULOG_CRIT("Could not create connection to DBUS: %s", error->message);
        g_clear_error (&error);
    } else {
        gchar *filter_string = NULL;
        DBusConnection *sys_conn;
        
        sys_conn = dbus_bus_get(DBUS_BUS_SYSTEM, NULL);
        g_assert(dbus_connection_add_filter(sys_conn,
                                            file_sent_signal,
                                            NULL,
                                            NULL ));
        filter_string =
           g_strdup_printf ("type='signal',interface='%s'", CONBTDIALOGS_DBUS_INTERFACE);
    
        dbus_bus_add_match(sys_conn, filter_string, NULL);
        dbus_connection_unref(sys_conn);
        
        /* Open connection for btdialogs service */
        proxy = dbus_g_proxy_new_for_name(connection,
                                          CONBTDIALOGS_DBUS_SERVICE,
                                          CONBTDIALOGS_DBUS_PATH,
                                          CONBTDIALOGS_DBUS_INTERFACE);
        g_free(filter_string);
    }

    return TRUE;
}

void deinit_osso_callback()
{
    static gboolean deinited = FALSE;

    if (!deinited) {
        /* Unset callbacks */
/*        osso_application_unset_top_cb(app_data->osso, 
                            (osso_application_top_cb_f *) osso_top_callback, NULL);*/
        
        osso_rpc_unset_cb_f(app_data->osso,
                OSSO_RSS_FEED_READER_SERVICE,
                OSSO_RSS_FEED_READER_OBJECT_PATH,
                OSSO_RSS_FEED_READER_INTERFACE,
                dbus_req_handler, app_data);

        osso_rpc_unset_cb_f(app_data->osso,
                DBUS_NEWS_SERVICE_NAME_REFRESH,
                DBUS_NEWS_SERVICE_PATH_REFRESH,
                DBUS_NEWS_INTERFACE_NAME_REFRESH,
                dbus_req_handler, app_data);

        deinited = TRUE;
    }
}

gboolean deinit_osso(AppData * app_data)
{
    g_assert(app_data != NULL);
        
    free_iap_type();
    
    ULOG_DEBUG("\n\n\n\ndeinit_osso\n\n\n\n");

    if (proxy)
        g_object_unref(G_OBJECT(proxy));
    if (connection)
        dbus_g_connection_unref(connection);
//        dbus_connection_close(connection);
    if (iap)
        g_object_unref(iap);

    deinit_osso_callback();

    osso_hw_unset_event_cb(app_data->osso, NULL);
    
    g_assert(app_data->osso);
    osso_deinitialize(app_data->osso);
    /* TODO: unregister osso_iap_cb() here */
    g_timer_destroy(messageTimer);

    return TRUE;
}

gboolean open_url(gchar * url)
{
    ULOG_DEBUG(__FUNCTION__);

/*    gboolean reuseWindow =
	getBooleanConfValue(RSS_SETTINGS_REUSE_BROWSER_WINDOW);*/

    gboolean reuseWindow = TRUE;
    
    g_assert(app_data != NULL);
    g_assert(app_data != NULL);
	
    osso_rpc_run_with_defaults(app_data->osso,
			       "osso_browser",
			       reuseWindow ? OSSO_BROWSER_LOAD_URL_REQ :
			       OSSO_BROWSER_OPEN_NEW_WINDOW_REQ, NULL,
			       DBUS_TYPE_STRING, url, DBUS_TYPE_INVALID);

    return TRUE;
}

gboolean _rss_dbus_signal_applet(gchar * signal)
{
    DBusMessage *message = NULL;
    GError *err = NULL;
    osso_context_t *osso;
     
    g_assert(app_data != NULL);

    ULOG_DEBUG("Signal applet: %s", signal);

    osso = app_data->osso;
  
    DBusConnection *connection = osso_get_dbus_connection(osso);
    ULOG_DEBUG(__FUNCTION__);

    message =
        dbus_message_new_signal
            (OSSO_RSS_FEED_READER_OBJECT_PATH,
             OSSO_RSS_FEED_READER_INTERFACE, signal);

    if (message == NULL) {
        ULOG_ERR("Failed to create signal %s", signal);
    }

    //dbus_message_set_auto_activation(message, FALSE);
    dbus_message_set_auto_start(message, FALSE); //new dbus v0.60 
    if (err == NULL && !(dbus_connection_send(connection, message, NULL))) {
        ULOG_ERR("Failed to send signal %s", signal);
    }

    if (message != NULL) {
        dbus_message_unref(message);
    }

    return FALSE;
}

gboolean rss_dbus_signal_applet(gchar * signal)
{
    g_timeout_add(0, (GSourceFunc) _rss_dbus_signal_applet, signal);
}

gboolean rss_dbus_refresh_completed()
{
    return
	rss_dbus_signal_applet
	(OSSO_RSS_FEED_READER_REFRESH_FINISHED_SIGNAL);
}


void bt_send(const gchar *title, gpointer data, size_t size)
{
/* TODO: unused variable, due to commented out function. Remove?
    const gchar *nl = "\n";
*/
    GError *error = NULL;
    gchar **files;
    int fd = 0;
    gchar *dtitle = NULL;
    
    if (!data)
        return;
    
    if (!connection || !proxy)
    {
	   ULOG_ERR("DBus was not initialized correctly!");
        return;
    }
    
    if (app_data->app_ui_data->bt_file)
    {
        ULOG_DEBUG("Bluetooth sending is already in progress");
        return;
    }
    
    dtitle = strip_invalid_char_from_fn(g_strdup(title));
    /* Copy urls to GLib compatible char array */
    files = g_new0(gchar*, 2);
    *files = g_strdup_printf("/tmp/%s.html", dtitle);
    files[1] = NULL;
    g_free(dtitle);

//    unlink(*files);

    ULOG_DEBUG("Sending file '%s' over bluetooth...", *files);

    if ((fd = creat(*files, S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH)) != -1)
    {
/*        //if it is not an URL write the title also
        if (strncasecmp(data, "http", 4) == 0) {
//            write(fd, title, strlen(title));
            write(fd, nl, strlen(nl));
        }*/
        write(fd, data, size);
        close(fd);
        
        app_data->app_ui_data->bt_file = g_strdup(*files);
    
        /* Send send file request to btdialogs service */
        if (!dbus_g_proxy_call(proxy, CONBTDIALOGS_SEND_FILE_REQ,
                               &error,
                               G_TYPE_STRV, files, G_TYPE_INVALID,
                               G_TYPE_INVALID))
        {
            ULOG_ERR("Error: %s", error->message);
            g_clear_error(&error);
        }
    }

//    g_free(*files);
    g_strfreev(files);
}

gboolean bt_avail()
{
    return connection && proxy;
}

inline void free_iap_type()
{
    if (app_data->app_ui_data->network_iap) {
        g_free(app_data->app_ui_data->network_iap);
        app_data->app_ui_data->network_iap = NULL;
    }
}

void find_iap_connection_type()
{
    free_iap_type();
    
    app_data->app_ui_data->network_iap = getStringConfValue(ICD_GCONF_CURRENT);
}
