/**
 * @file conf.h Liferea configuration (gconf access and feedlist import)
 *
 * Copyright (C) 2003, 2004 Lars Lindner <lars.lindner@gmx.net>
 * Copyright (C) 2004 Nathan J. Conrad <t98502@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _CONF_H
#define _CONF_H

#include <glib.h>
#include "folder.h"

/** Initializes the configuration 
  */
void conf_init(void);

/** Sets values to certain gconf keys
  */
void conf_load(void);

/* feed/directory list entry manipulation methods */

/** Creates a new cache id
  *
  * @return the new id
  */
gchar *conf_new_id();

/** Loads the feedlist from a file
  */
void conf_load_subscriptions();

/** Schedules a feedlist save into a file
  */
void conf_feedlist_schedule_save();

/** Saves the feedlist into a file
  */
void conf_feedlist_save();

/* methods to modify folder contents */

/** Checks if namespace is enabled in configuration
  * @param nsname namespace
  * @return TRUE if namespace is enabled in configuration
  */
gboolean getNameSpaceStatus(gchar * nsname);

/** Used to enable/disable a namespace in configuration 
  *
  * @param nsname namespace
  * @param enable used to enable or disable a namespace
  */
void setNameSpaceStatus(gchar * nsname, gboolean enable);

/** Checks ia a given conf value is initialized
  *
  * @param valuename the value to check
  * @return TRUE if initialized, FALSE otherwise
  */
gboolean checkConfValueExist(gchar * valuename);

/** Gets a boolean value from gconf
  * 
  * @param valuename the name of the value
  * @return the wanted value
  */
gboolean getBooleanConfValue(gchar * valuename);

/** Gets a string value from gconf
  * 
  * @param valuename the name of the value
  * @return the wanted value
  */
gchar *getStringConfValue(gchar * valuename);

/** Gets a numeric value from gconf
  * 
  * @param valuename the name of the value
  * @param def default value if not exists in the config
  * @return the wanted value
  */
gint getNumericConfValue(gchar * valuename);
gint getNumericConfValueDef(gchar * valuename, gint def);

/** Sets a boolean value to gconf
  * 
  * @param valuename the name of the value
  * @param value the value to set
  */
void setBooleanConfValue(gchar * valuename, gboolean value);

/** Sets a string value to gconf
  * 
  * @param valuename the name of the value
  * @param value the value to set
  */
void setStringConfValue(gchar * valuename, gchar * value);

/** Sets a numeric value to gconf
  * 
  * @param valuename the name of the value
  * @param value the value to set
  */
void setNumericConfValue(gchar * valuename, gint value);


//gboolean isFirstTimeRun();

#endif
