/**
    @file applet_cache.h

    Applet cache functionality.

    Copyright (c) 2004-2005 Nokia. All rights reserved.
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/


#ifndef _APPLET_CACHE_H
#define _APPLET_CACHE_H

#include <time.h>
#include <gtk/gtk.h>
#include <glib.h>

typedef struct {
    time_t time;
    gchar *feed;
    gchar *title;
	gchar *description;
    GdkPixbuf *icon;
    guint32 nr;
} HeadLine;

/**
 * Reads through all feed caches in the feed directory,
 * returning a GList of HeadLine structs sorted on time,
 * which needs to be freed by caller.
 * @return a sorted list of headline structs
 */
GList *feed_load_all();

/** Calls the general_load function with the correct path for the
  * saved data
  *
  * @param applet the applet structure
  */
void do_general_load(AppletInfo *applet);

/** Tests if the cache directory exists and creates it if
  * it doesnt
  */
void test_if_cache_directory_exists();
#endif
