/**
    @file applet.h

    Copyright (c) 2004-2005 Nokia. All rights reserved.
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/


#ifndef _APPLET_H
#define _APPLET_H

#include <time.h>
#include <gtk/gtk.h>
#include <glib.h>

/* GConf */
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

/* D-BUS */
#include <dbus/dbus-glib-lowlevel.h>

#include <osso-ic.h>

#include <hildon-widgets/hildon-defines.h>

#define RSS_APPLET_WIDTH 390
#define RSS_APPLET_HEIGHT 350
#define RSS_APPLET_SCROLLED_WINDOW_HEIGHT 300

#define RSS_SETTINGS "/apps/osso/rss-feed-reader"
#define RSS_SETTINGS_REUSE_BROWSER_WINDOW "/apps/osso/rss-feed-reader/reuse-browser-window"
#define RSS_SETTINGS_NEWEST_POSTS_FIRST "/apps/osso/rss-feed-reader/item-sort-order"
#define RSS_SETTINGS_AUTOMATIC_UPDATES "/apps/osso/rss-feed-reader/automatic-update"
#define RSS_SETTINGS_AUTOMATIC_UPDATES_INTERVAL "/apps/osso/rss-feed-reader/update-interval"

#define NEWS_SERVICE_NAME "com.nokia.osso_rss_feed_reader"
#define NEWS_SERVICE_OBJECT "/com/nokia/osso/rss_feed_reader"
#define NEWS_INTERFACE_NAME "com.nokia.osso_rss_feed_reader"

#define OSSO_RSS_FEED_READER_APPLET_SERVICE "com.nokia.osso_rss_feed_reader"
#define OSSO_RSS_FEED_READER_APPLET_INTERFACE "com.nokia.osso_rss_feed_reader"
#define OSSO_RSS_FEED_READER_APPLET_OBJECT_PATH "/com/nokia/osso/rss_feed_reader"



#define APPLET_DBUS_SIGNAL_LISTENER_FMT "type='signal',sender='%s',"\
    "interface='%s'"

/* Define d-bus messages, to which application have to react */

#define OSSO_RSS_FEED_READER_REFRESH_SIGNAL "refresh"
#define OSSO_RSS_FEED_READER_DISPLAY_SIGNAL "display"

#define OSSO_RSS_FEED_READER_REFRESH_FINISHED_SIGNAL "refresh_finished"
#define OSSO_RSS_FEED_READER_REFRESH_PREVENTED_SIGNAL "refresh_prevented"
#define OSSO_RSS_FEED_READER_REFRESH_INTERRUPTED_SIGNAL "refresh_interrupted"
#define OSSO_RSS_FEED_READER_FOLDER_READ_SIGNAL "folder_read"
#define OSSO_RSS_FEED_READER_REFRESH_STARTED "refresh_started"
#define OSSO_RSS_FEED_READER_CONNECTING_STARTED "connecting_started"

#define RSS_ICON_ITEM "qgn_list_home_newsreader_post"

#define	TIMESTRLEN	30
#define MIN_INTERVAL 1

gint _setup_alarmd(gpointer data);

/**
 Set hardware event handler

 @param state Signals that are of interest
 @param cb Callback function.
 @param data Application specific data.
 */

gboolean set_hw_event_handler(osso_hw_state_t * state,
                              osso_hw_cb_f * cb, gpointer data);


typedef struct {
    gchar *data;
    gint length;
} result_buffer;

typedef struct {
    void *state_data;
    gboolean startrss;
    int state_size;
    /* Global counters */
    time_t updated;
    gulong unread;
    /* UI widgets */
    GtkWidget *appletframe;
    GtkWidget *news;
    GtkWidget *rss_news;          //TreeView
	GtkWidget *scrolledwindow;			//The TreeView's scrolled window
    GtkWidget *rss_image; 				//The refresh image
	GtkWidget *rss_image_pressed;		//The pressed refresh image
	GtkWidget *rss_image_stop;			//The stop image
	GtkWidget *rss_image_stop_pressed;	//The pressed stop image
    GtkWidget *rss_unread;
    GtkWidget *rss_updated;
    GtkWidget *rss_refresh;
    GtkWidget *empty_label;
    GtkWidget *applet_vbox;
//    GtkWidget *label_and_news_box;
//    GtkWidget *event_box;
    GtkWidget *appl_frame;
    GtkWidget *refresh_banner;
    GtkCellRendererText *textRenderer;
    GtkTreeViewColumn *textColumn;
    GtkLayout *layout;
    /*We need TreeStore, not ListStore in SP+*/
    /*GtkListStore *headlines;*/
	GtkTreeStore *headlines;
    /* Update tracking */
    gboolean online;
    guint timeout;
    /* GConf */
    gboolean update;
    guint interval;
    GConfClient *client;
    int width;
    DBusConnection *connection;
    gboolean refreshing;
    gboolean refresh_banner_displayed;
    osso_context_t *osso;
    gboolean backgrounded;
    gchar *title_backup;
    gchar *title_backup2;
    guint gconf_notify_id1;
    guint gconf_notify_id2;
    guint gconf_notify_id3;
    
    gint avg_char_width;
    gint chars_per_line;
    gint line_height;
    gint displayed_lines;

    gint prev_width;
    gint prev_height;
} AppletInfo;

enum {
    ICON_COLUMN,
    RENDER_COLUMN,
    TITLE_COLUMN,
    DESCRIPTION_COLUMN,
    FEED_COLUMN,
    ITEMNR_COLUMN,
    N_COLUMNS,
};

#endif
