/**
    @file interface.h

    Definitions for general user interface functionality.

    Copyright (c) 2004-2006 Nokia Corporation.
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/


#ifndef INTERFACE_H
#define INTERFACE_H


#include <gtk/gtk.h>
#include <hildon-widgets/hildon-app.h>

#include "constant.h"
#include "appdata.h"
#include "state_save.h"
#include "pdfviewer.h"


typedef void (*InsensitiveMenuPressCallback) (GtkWidget *, gpointer);


/**
	Public interface
*/

void ui_create_main_window    (AppData   *app_data);

void ui_run_file_chooser      (AppUIData *app_ui_data,
			       GtkFileChooserAction action);

void ui_run_switch_page_dialog(AppUIData *app_ui_data);

void ui_run_details_dialog    (AppUIData *app_ui_data);

void ui_toggle_fullscreen     (AppUIData *app_ui_data, 
			       gboolean   fullscreen);

void ui_set_fullscreen        (AppUIData *app_ui_data, 
			       gboolean   fullscreen);

void ui_update_current_page   (AppUIData *app_ui_data);

void ui_open_recent_item      (AppUIData *app_ui_data, 
			       gint       index);

void ui_refresh_recent_menu(AppUIData * app_ui_data);

void ui_update_recent_menu    (AppUIData *app_ui_data);

/* The 'extern c' calling convention is required as this
   is called from the 'pdfviewer' component as well. */
#ifdef __cplusplus
extern "C" {
#endif

  void idle_delete(gpointer data);
  
    void ui_open_document(AppUIData   *app_ui_data, 
				     const gchar *filename,
				     const gchar *password);
/**
	Dim helper function (was: dim_functions).
	A function for enabling and disabling buttons on the toolbar
	Moved to here from 'pdfviewer'
	
	@param app_ui_data AppUIData object
	@param dim control to set
	@param TRUE to enable, FALSE to disable
*/
    void ui_enable_page_controls(AppUIData * app_ui_data, PDFDim dim,
				 gboolean enable);

/**
	Dim helper function 2 (was: dim_functions).
	A function for enabling and disabling document controls.
	
	@param app_ui_data AppUIData object
	@param dim control to set
	@param TRUE to enable, FALSE to disable
*/
    void ui_enable_document_controls(AppUIData   *app_ui_data,
				 gboolean    enable);
    
    void ui_enable_document_open(AppUIData   *app_ui_data,
				 gboolean    enable);

/**
	Enable or disable scrollbars
	
	@param app_ui_data AppUIData object
	@param henable show or hide horizontal scrollbar
	@param venable show or hide vertical scrollbar
*/
    void ui_enable_scrollbars(AppUIData * app_ui_data,
			      gboolean henable, gboolean venable);


/**
   Sets application UI to the correct state according to the state data.
   Loads PDF document if necessary.

   @param app_ui_data AppUIData object (not NULL)
   @param app_state application state object (not NULL)
 */
    void ui_load_state(AppUIData * app_ui_data, AppState * app_state);


/**
   Launches osso-help to show a help topic.

   @param app_ui_data AppUIData object (not NULL)
   @param help_topic help topic id (not NULL)
 */
    void ui_run_help(AppUIData * app_ui_data, gchar * help_topic);


/**
   Checks if the given toolbar item is sensitive.
  
   @param app_ui_data AppUIData object (not NULL)
   @param PDFDim - toolbar item
   @return TRUE if sensitve else FALSE 
*/
    gboolean ui_get_toolitem_is_sensitive(AppUIData * app_ui_data,
					  PDFDim dim);

/**
   Show an information banner in application window

   @param GtkWindow application window
   @param information string
*/
    void ui_show_banner(GtkWidget * widget, const gchar *msg);

/**
   Show a progress banner in application window

   @param GtkWindow application window
   @param information string
*/
    GtkWidget *ui_show_progress_banner(GtkWindow * app_window, const gchar *msg);

/**
   Show an information note - with OK button - in application window
   
   @param GtkWindow application window
   @param information string
*/
    void ui_show_note(GtkWindow * app_window, const gchar *msg);


/**
   Show the PDFViewerResult in the proper way
   
   @param AppUIData
   @param PDFViewerResult
*/
    void ui_show_result(AppUIData *app_ui_data, PDFViewerResult result);

/**
   Sets current zoom

   @param app_ui_data AppUIData structure
   @param value zoom value
   @return void
*/
    void ui_set_current_zoom(AppUIData *app_ui_data, int value);

/**
   Set image of switcheer on toolbar
*/
    void ui_set_images_mode( AppUIData *app_ui_data, int sign );

/**
   Update every menu/toolbar item on the UI
   according to the application's state

   @param AppUIData
*/
    void ui_update(AppUIData *app_ui_data);

#ifdef __cplusplus
}
#endif

#endif				/* INTERFACE_H */
