/***************************************************************************
                          main.c  -  description
                             -------------------
    begin                : Sam Aug  5 12:36:32 MEST 2000
    copyright            : (C) 2000 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

#ifdef _WIN32
#include <fcntl.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <osso-log.h>
#include <shadowapp.h>
#include "menu.h"
#include "cfg.h"
#include "levels.h"
#include "timer.h"
#include "sdl.h"
#include "audio.h"
#include "profile.h"
#include "game.h"
#include "engine_main.h"

// sappdata -- main.c //
extern sapp_data *sapp_context;
// timer -- timer.c //
extern struct timeb t_c, t_lc;
// quit game quickly ? //
int     trm_gm = 0;
// menu config -- cfg.c //
extern  Cfg cfg;
// sdl struct //
extern Sdl sdl;
// levelset list and number of entries -- levels.c //
extern char **ls_lst;
extern int  ls_n;
// profiles //
extern DLst prfs;
// string list for the menu -- profile.c //
extern char **prf_lst;
extern int  prf_n;
// menu entry containing the profile list //
// MEnt *me_prf, *me_del, *me_clr;

// menu actions MUST BE GREATER THAN 0 //
#define MA_NONE 0
#define MA_QUT 1
#define MA_PLY 2
#define MA_HSC 3

void CB_Snd(void);
void CB_StV(void);
void CB_CrtP(void);
void CB_ClrP(void);
void CB_DelP(void);
void CB_SrtP(void);
void event_clear_sdl_queue(void);
int all_filter(const SDL_Event *event);
void H_Shw(void);
// void MM_CrtE(void);


/*
====================================================================
Clear the SDL event key (keydown events)
====================================================================
*/
int all_filter( const SDL_Event *event )
{
    event = event;
    return 0;
}
void event_clear_sdl_queue()
{
    SDL_Event event;
    SDL_SetEventFilter( all_filter );
    while ( SDL_PollEvent( &event ) );
    SDL_SetEventFilter( 0 );
}

/*
    previously defined hiscore.h but this file no longer needed
*/
typedef struct {
	char	nm[12];
	int		lvl;
	int     lvs;
	int		scr;
	int     pct;
} H_E;

/*
    show hiscore and highlight rank r
void H_Shw()
{
	int i, j;
    SDL_Surface *buf = 0;
	SFnt *ft;
	Prf *p;
	int off = 50;
	int a_y = 100;
	char str[12];
    int e_num = prfs.cntr > 10 ? 10 : prfs.cntr;
    H_E hscr[e_num];
    DL_E *e;

    // save screen //
    buf = SS_Crt(sdl.scr->w, sdl.scr->h, SDL_SWSURFACE);
    D_FDST(buf);
    D_FSRC(sdl.scr);
    SS_Blt();
    // darken screen //
    if (cfg.dim)
        SDL_DIM();

    // draw background //
    D_FDST(sdl.scr);
    D_FSRC(mm.ss_bkgd);
    SS_Blt();
    // brighten screen //
    if (cfg.dim)
        SDL_UNDIM();
    else
        Sdl_FUpd();

    // create highscore list //
    memset(hscr, 0, sizeof(hscr));
    e = prfs.hd.n;
    while (e != &prfs.tl) {
        p = (Prf*)e->d;
        for (i = 0; i < e_num; i++)
            if (p->scr >= hscr[i].scr) {
                for (j = e_num - 1; j > i; j--)
                    hscr[j] = hscr[j - 1];
                hscr[i].scr = p->scr;
                hscr[i].pct = p->pct;
                hscr[i].lvl = p->lvls;
                strcpy(hscr[i].nm, p->nm);
                break;
            }
        e = e->n;
    }

    // write hiscores //
	
    SF_Wrt(mm.ft_nml, sdl.scr, sdl.scr->w / 2, 50, "Best Profiles", 0);
    mm.ft_nml->algn = mm.ft_sel->algn = TA_X_L | TA_Y_T;

    for (i = 0; i < e_num; i++) {
        if (0) // changed later
            ft = mm.ft_sel;
        else
            ft = mm.ft_nml;
        ft->algn = TA_X_L | TA_Y_T;
        SF_Wrt(ft, sdl.scr, off, a_y + i * e_h, hscr[i].nm, 0);
        ft->algn = TA_X_C | TA_Y_T;
        sprintf(str, "%i", hscr[i].lvl);
        SF_Wrt(ft, sdl.scr, sdl.scr->w / 2, a_y + i * e_h, str, 0);
        sprintf(str, "%i", hscr[i].scr);
//        sprintf(str, "%i (%i.%i%%)", hscr[i].scr, hscr[i].pct / 10, hscr[i].pct % 10);
        ft->algn = TA_X_R | TA_Y_T;
        SF_Wrt(ft, sdl.scr, sdl.scr->w - off, a_y + i * e_h, str, 0);
    }

    mm.ft_nml->algn = mm.ft_sel->algn = TA_X_C | TA_Y_C;
    Sdl_FUpd();

    // wait for a click //
    Sdl_WtFrClk();

    //darken screen //
    if (cfg.dim)
        SDL_DIM();
    // restore screen //
    D_FDST(sdl.scr);
    D_FSRC(buf);
    SS_Blt();
    // brighten screen //
    if (cfg.dim)
        SDL_UNDIM();
    else
        Sdl_FUpd();

    // reset timer //
    T_Rst();
}
*/

// menu callbacks //

/*
    activate / deactivate sound
*/
void CB_Snd()
{
#ifdef SOUND
    sound_enable(cfg.s_on);
#endif
}

/*
    set sound volume
*/
void CB_StV()
{
#ifdef SOUND
    sound_volume(cfg.s_vol * 16);
#endif
}

/*
    clear a profile
*/
void CB_ClrP()
{
    Prf *p = DL_Get(&prfs, cfg.prf);
    DL_Clr(&p->sts);
    p->lvls = 0;
    p->scr = 0;
    p->pct = 0;
}

void CB_SrtP()
{
//    Prf_Srt();
}

/*
    init sound, menu, profiles, game
    main loop for the menu
*/
int lmarbles(int argc, char *argv[])
{
    (void)argc;
    (void)argv;
/*    SDL_Event   e;
    int         go_on = 1;
    int         ms; */
    char aux[64];
    char tmp;
#ifdef _WIN32
    /* Get Windows to open files in binary mode instead of default text mode */
    _fmode = _O_BINARY;
#endif
    
    // random init
    srand(time(NULL));
  
    // sdl init //
#ifdef SOUND
    Sdl_Ini(SDL_INIT_VIDEO | SDL_INIT_TIMER);
#else
    Sdl_Ini(SDL_INIT_VIDEO | SDL_INIT_TIMER);
#endif
    sprintf( aux, _("game_ap_marbles_name"));
    SDL_WM_SetCaption(aux, 0);
    tmp = 0;
  if (sapp_gconf_request_bool(sapp_context, "/apps/osso/lmarbles/running", &tmp))
  {
    return 1;
  }
  if ((int)tmp!=1)
  {
    return 1;
  }

    // show logo //
    Sdl_StVdMd(800, 480, 16, SDL_SURFACE_TYPE | SDL_FULLSCREEN);

    // load config //
    C_StPth();
    C_Ld();

//#define WORKAROUND
    // get difficulty from startup //
    cfg.diff = 0;
#ifndef WORKAROUND
    if (sapp_gconf_request_int(sapp_context, "/apps/osso/lmarbles/difficulty_level", &cfg.diff))
	    cfg.diff = 0;
#endif

    // get sound setting from startup //
    
#ifndef WORKAROUND
    if (sapp_gconf_request_bool(sapp_context, "/apps/osso/lmarbles/enable_sound", &tmp))
	    tmp = 0;
#endif
    cfg.s_on = (int)tmp;

    FILE *dFile;
    if ((dFile = fopen("/tmp/.gamewrapper/lmarbles.debug", "a"))) {
	    fprintf(dFile, "Sound: %d\n", cfg.s_on);
	    fclose(dFile);
    }

    // load profiles //
    Prf_Ini();
    if (!Prf_Ld())
        cfg.prf = 0;

    // create levelset list and reset config's levelset index if nescessary //
    L_CrtLst();
    if (cfg.ls >= ls_n)
        cfg.ls = 0;

#ifdef SOUND
    audio_open();
    sound_enable( cfg.s_on );
    sound_volume( cfg.s_vol * 16 );
#endif
		
    // game init //
    G_Ini();
  if (sapp_gconf_request_bool(sapp_context, "/apps/osso/lmarbles/running", &tmp))
  {
    return 1;
  }
  if ((int)tmp!=1)
  {
    Sdl_Qut();
    return 1;
  }
    /*
    // init and show menu//
    MM_CrtE();
    MM_Shw(MM_RSZ);

    event_clear_sdl_queue();
    //menu loop
    T_Rst(); // reset time //
    while (go_on && !trm_gm) {
        M_Hd(mm.c_mn);
        if (SDL_PollEvent(&e)) {
            if (e.type == SDL_QUIT)
                trm_gm = 1;
            if (e.type == SDL_KEYUP && e.key.keysym.sym == SDLK_ESCAPE)
                go_on = 0;
            switch (MM_Evt(&e)) {
                case MA_QUT:
                    go_on = 0;
                    break;
                case MA_PLY:
		*/
                    if (G_Opn()) {
                        G_Run();
                        G_Cls();
                    }
		/*
                    break;
                case MA_HSC:
                    M_Shw(mm.c_mn);
                    Sdl_UpdR();
                    H_Shw(); // defined in main.c //
                    break;
            }
        }
        ms = T_Gt();
        M_CmA(mm.c_mn, ms);
        M_Shw(mm.c_mn);
        Sdl_UpdR();
        SDL_Delay( 5 );
    }

    // terminate menu //
    MM_Trm();
    */
    // terminate game //
    G_Trm();

    // close soundserver //
#ifdef SOUND
    audio_close();
#endif

    // save config //
    C_Sv();

    // free levelset list //
    L_DelLst();

    // save profiles //
    Prf_Sv();
    Prf_Trm();

    // free screen //
    Sdl_Qut();

    ULOG_DEBUG("Bye, bye!\n");

    return 0;
}
