/**
    @file constant.h

    Constants.

    Copyright (c) 2004, 2005 Nokia Corporation.
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/

#ifndef CONSTANT_H
#define CONSTANT_H

/**
   D-BUS
*/

/* D-BUS service definitions */
#define OSSO_LMARBLES_SERVICE "com.nokia.osso_lmarbles"
#define OSSO_LMARBLES_OBJECT_PATH "/com/nokia/osso_lmarbles"
#define OSSO_LMARBLES_INTERFACE "com.nokia.osso_lmarbles"

/* Define d-bus messages, to which appliction have to react */
#define OSSO_LMARBLES_RUN_METHOD "osso-lmarbles-run"
#define OSSO_LMARBLES_CONTINUE_METHOD "osso-lmarbles-continue"
#define OSSO_LMARBLES_RESTART_METHOD "osso-lmarbles-close"
#define OSSO_LMARBLES_CLOSE_METHOD "osso-lmarbles-pause"

/**
   GConf
*/

/* Application specific GConf keys */
#define GCONF_LMARBLES_SOUND TRUE
#define GCONF_LMARBELS_DIFFICULTY_LEVEL 1

/**
   Other
*/

/* Application errors */
typedef enum {
  LMARBLES_NO_ERROR = 0,
  LMARBELS_ERROR
} AppError;

#endif /* CONSTANT_H */
