/**
   @file callbacks.c

   Osso Lmarbles callback functions.

    Copyright (c) 2004, 2005 Nokia Corporation.
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/

#include "appdata.h"
#include "main.h"
#include "callbacks.h"
#include "game.h"

#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <memory.h>
#include <SDL/SDL.h>
#include <shadowapp.h>
#include <libintl.h>
#include <locale.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

extern SDL_TimerID escape_timeout;

extern int trm_gm;
extern sapp_data *sapp_context;
extern int home_pressed;
extern int exiting_needed;

int exit_callback(int errcode/*, AppData *app_data*/)
{
  FILE *dFile, *pFile;
  time_t rawtime;
  struct tm *timeinfo;
  char *printable;
  exiting_needed=1;
  
/*  dFile = app_data->app_dbg_data->dFile;
  pFile = app_data->app_dbg_data->pFile;
  rawtime = app_data->app_dbg_data->rawtime;
  timeinfo = app_data->app_dbg_data->timeinfo;
  printable = app_data->app_dbg_data->printable;
*/
  gchar *file = g_build_filename(
      g_get_home_dir(),
      ".lmarbles_state",
      NULL);
  pFile = g_fopen(file, "wb");
  if(pFile) {
    char *state = StateDump();
    fprintf(pFile, "%s", state);
    free(state);
    fclose(pFile);
  }
  g_free(file);
  /* else {
    _dprint("hjee", app_data);
  }

  */
  dFile = fopen("/tmp/sappdebug.txt", "a");
  if(dFile) {
    rawtime = time(NULL);
    timeinfo = localtime(&rawtime);
    printable = asctime(timeinfo);
    fprintf(dFile, "%s\texit callback called with exit code %d\n", printable, errcode);
    fclose(dFile);
  }

  /* sapp_pause(sapp_context); */
  trm_gm = 1;

//  app_data->app_osso_data->loopactive = 0;
  
  return 0;
}

int quit_callback(int errcode/*, AppData *app_data*/)
{
//  _dprint("glorious quit callback", app_data);

   FILE *dFile;
  char    buf[1024];
  errcode = errcode;

  gchar *file = g_build_filename(
      g_get_home_dir(),
      ".lmarbles_state",
      NULL);
  dFile = g_fopen(file, "r");
  if (dFile) {
    buf[fread(buf, 1, 1023, dFile)] = '\0';
    fclose(dFile);
    buf[2] = '\0';
    dFile = g_fopen(file, "wb");
    if (dFile)
    {
      fprintf(dFile, "%s", buf);
      fclose(dFile);
    }
  }

  trm_gm = 1;
  /* Only called when game not running, these are unnecessary */
/*  app_data->app_osso_data->loopactive = 0;
  app_data->app_osso_data->quitt = 1; */
  
  return 0;
}

int flush_callback(int errcode)
{
  FILE *dFile;
  errcode = errcode;
  dFile = fopen("/tmp/sappdebug.txt", "a");
  char buf[1024];
  if(dFile) {
    fprintf(dFile, "flush callback called with exit code %d\n", errcode);
    fclose(dFile);
  }

  gchar *file = g_build_filename(
      g_get_home_dir(),
      ".lmarbles_state",
      NULL);

  dFile = g_fopen(file, "r");
  if (dFile) {
    buf[fread(buf, 1, 1023, dFile)] = '\0';
    fclose(dFile);
    buf[2] = '\0';
    dFile = g_fopen(file, "wb");
    if (dFile)
    {
      fprintf(dFile, "%s", buf);
      fclose(dFile);
    }
  }
  
  return 0;
}

Uint32 app_escape_timeout(Uint32 interval, void *param)
{
  (void)param;
  
  static SDL_Event ev;
  ev.type = SDL_USEREVENT;
  SDL_PushEvent(&ev);
  
  app_remove_timeout();
     
  return interval;
}

void app_remove_timeout(void)
{
  if (escape_timeout != NULL) {
    SDL_RemoveTimer(escape_timeout);
    escape_timeout = NULL;
  }
}

void app_set_pause_hw_key(int keyval)
{
  GConfClient *gc_client = NULL;
  
  g_type_init();
  gc_client = gconf_client_get_default();
  if (gc_client != NULL) {
    //gconf_client_set_int(gc_client, PAUSE_WITH_HW_KEY, keyval, NULL);
    if (keyval==286)
    {
      home_pressed=1;
    }
    
    g_object_unref(gc_client);
    gc_client = NULL;
  }  
}

/*
  Call this function in time consuming loops, because we want to run
  osso (dbus) for hw-events.
*/
void gmainloop(void) {
  while (g_main_context_iteration(g_main_context_default(),FALSE));
}
