/**
    @file appdata.h

    Data structures for the whole application.

    Copyright (c) 2004, 2005 Nokia Corporation.
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/

#ifndef APPDATA_H
#define APPDATA_H

#ifdef HAVE_CONFIG
#include <config.h>
#endif

#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <memory.h>
#include <SDL/SDL.h>
#include <shadowapp.h>

#if 0
typedef struct _AppData AppData;
typedef struct _AppSDLData AppSDLData;
typedef struct _AppOSSOData AppOSSOData;
typedef struct _AppConfData AppConfData;
typedef struct _AppDbgData AppDbgData;

/* Application data */
struct _AppData {
  AppSDLData *app_sdl_data;
  AppOSSOData *app_osso_data;
  AppConfData *app_conf_data;
  AppDbgData *app_dbg_data;

  /* Demo variables */
  int spx, spy, svx, svy;
};

/* Application configuration data */
struct _AppConfData {
  /* GConf variables */
  GConfClient *gc_client;
};

/* Application osso data */
struct _AppOSSOData {
  /* Shadow application context */
  sapp_data *sapp_context;
  sapp_d_data *main_context;  
  int loopactive;
  int quitt;
};

/* Application SDL data */
struct _AppSDLData {
  SDL_Event event;
  SDL_Surface *screen, *smiley;
  SDL_Rect r_src, r_dest;
};

/* Application Debug data */
struct _AppDbgData {
  FILE *dFile, *pFile;
  time_t rawtime;
  struct tm *timeinfo;
  char *printable;
};
#endif
#endif /* APPDATA_H */
