/**
  @file bt-error.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2006 Nokia Corporation. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/
#ifndef _BT_ERROR_H_
#define _BT_ERROR_H_

#include <glib.h>
#include <dbus/dbus.h>

const char *bt_dbus_error(GError *err);

gboolean bt_set_g_error(GError **err, DBusError *derr);

GQuark bt_cond_error_quark(void);

#define BT_COND_ERROR bt_cond_error_quark()

typedef enum {
    BT_COND_ERROR_INVALID_SVC,
    BT_COND_ERROR_INVALID_DEV,
    BT_COND_ERROR_CONNECTED,
    BT_COND_ERROR_BOUND,
    BT_COND_ERROR_NOT_CONNECTED,
    BT_COND_ERROR_NOT_BOUND,
    BT_COND_ERROR_BT_DISABLED,
    BT_COND_ERROR_CONNECT_FAILED,
    BT_COND_ERROR_AUTH_FAILED,
    BT_COND_ERROR_SMALL_CRYPT_KEY,
    BT_COND_ERROR_CANCELLED,
    BT_COND_ERROR_FAILED
} BtCondError;


GQuark bt_sdp_error_quark(void);

#define BT_SDP_ERROR bt_sdp_error_quark()

typedef enum {
    BT_SDP_ERROR_BT_DISABLED,
    BT_SDP_ERROR_CONNECT_FAILED,
    BT_SDP_ERROR_IN_PROGRESS,
    BT_SDP_ERROR_FAILED
} BtSdpError;


GQuark bt_search_error_quark(void);

#define BT_SEARCH_ERROR bt_search_error_quark()

typedef enum {
    BT_SEARCH_ERROR_BT_DISABLED,
    BT_SEARCH_ERROR_NO_SEARCH,
    BT_SEARCH_ERROR_IN_PROGRESS,
    BT_SEARCH_ERROR_FAILED
} BtSearchError;

#endif /* _BT_ERROR_H_ */

