/**
    @file callbacks.h

    Function definitions for user interface callbacks.

    Copyright (c) 2004, 2005 Nokia Corporation.
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/

#ifndef CALLBACKS_H
#define CALLBACKS_H

/* GTK */
#include <gtk/gtk.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "startup_highscore.h"
#include "interface.h"
#include "settings.h"
#include "startup_i18n.h"

#define STARTUP_UNTOP 50




enum { chess_human_invalid=-1, chess_human_white=0, chess_human_black };
enum { chess_opponent_1=0, chess_opponent_2, chess_opponent_3,
       chess_opponent_4, chess_opponent_human };
enum { mahjong_board_invalid=-1, mahjong_board_1=0, mahjong_board_2,
       mahjong_board_3, mahjong_board_4, mahjong_board_5, mahjong_board_6,
       mahjong_board_7, mahjong_board_8 };
enum { lmarbles_difficulty_invalid=-1, lmarbles_difficulty_1=0,
       lmarbles_difficulty_2, lmarbles_difficulty_3,
       lmarbles_difficulty_4 };

GnomeVFSMonitorHandle *gnomevfs_handle;
gboolean is_new_file;

/**
	Undimm everything, when it was dimmed before

	@param data Pointer to the AppData.
*/
void undimm_everything(AppData *ad);

/**
	Dimm everything, because the memory is low

	@param data Pointer to the AppData.
*/
void dimm_everything(AppData *data);

/**
	Handle response events on the no-memory dialog.

	@param dialog Widget that received the event.
*/     

void save_nomem_response(GtkDialog *dialog,gint arg1,gpointer user_data);

       
/**
	Handle key press events on the no-memory dialog.

	@param widget Widget that received the event.
	@param event The event that occurred.
	@param data Pointer to the AppUIData.
	@return TRUE if handled, FALSE otherwise.
*/     
gboolean save_nomem_key_press(GtkWidget *widget, GdkEventKey *event, gpointer data);
       
/**
	Handle key press events on dialog.

	@param widget Widget that received the event.
	@param event The event that occurred.
	@param data Pointer to the AppUIData.
	@return TRUE if handled, FALSE otherwise.
*/
gboolean dialog_key_press(GtkWidget *widget, GdkEventKey *event, gpointer data);
   
	 
/* Callback function when a game returns */
void 
startup_ui_top_cb (AppUIData *app, 
                   gpointer    data);	   
/* The callback function to restart the game. It is connected to the reset button */
void startup_ui_game_restart_cb (GtkWidget *widget,gpointer data);

/* D-bus event handler function for indt games */	   
gint startup_app_rpc_event_cb (const gchar *interface, const gchar *method,GArray      *args, 
                          gpointer     data, 
                          osso_rpc_t  *retval);
	   
/* top event cb for indt games */
void 
startup_app_top_event_cb (const gchar *arguments, 
                    gpointer     data);

	   
/** 
	   The callback function to close the application 
 */
void 
startup_ui_game_quit_cb (GtkWidget *widget,gpointer data);
/**
	 The callback function to start the INDT game. It is connected to the play button
*/	   
void startup_ui_game_play_cb (GtkWidget *widget, gpointer   data);
	   
	   
/**
   The callback function to the state change
*/	   
void startup_ui_state_change_cb (AppUIData *app, guint oldstate, guint newstate,gpointer data);

/**
   The callback function for the menu when a INDT game is running.
*/
void startup_ui_menu_action_cb (gpointer   data, guint action, GtkWidget *menu_item);
	   
/**
   Menu action callback for regular menu items

   @param cb_data    Callback data, in our case pointer to AppData
   @param cb_action  Callback action, used to identify selected menuitem
   @param menu_item  Widget which emerged the event, set by GTK
 */
void menu_action( gpointer cb_data, guint cb_action, GtkWidget *menu_item );

/**
   Menu action callback for radio button -type menu items

   @param cb_data    Callback data, in our case pointer to AppData
   @param cb_action  Callback action, used to identify selected radiobutton
   @param menu_item  Widget which emerged the event, set by GTK
 */
void menu_radio( gpointer cb_data, guint cb_action, GtkWidget *menu_item );

/**
   Menu action callback for toggle -type menu items

   @param cb_data    Callback data, in our case pointer to AppData
   @param cb_action  Callback action, used to identify selected toggle
   @param menu_item  Widget which emerged the event, set by GTK
 */
void menu_toggle( gpointer cb_data, guint cb_action, GtkWidget *menu_item );

/**
   Toolbar test button callback function

   @param widget   Widget which emerged signal
   @param data     User data
 */
void test_button_clicked( GtkWidget *widget, gpointer data );

/**
   Callback top pop up our popupmenu

 */
gboolean show_popup( GtkWidget *widget, GdkEvent *event,
		     GtkWidget *menu );

/**
  Creates GtkTreeModel from high score data
 */
GtkTreeModel *create_highscore_list(struct HighScore *scores);

/**
  Sets save game dimmed or undimmed

  @param app_ui_data AppUIData structure
  @param dimmed TRUE to undim save options, FALSE to dim
 */
void menu_set_save_dimmed(AppUIData *app_ui_data, gboolean dimmed);

/**
  Callback for chess human player selection change

  @param widget Caller widget
  @param data Extra data given by the caller
 */
void chess_human_cb(GtkWidget *widget, gpointer data);

/**
  Callback for chess human player selection from the menu

  @param widget Caller widget
  @param data Extra data given by the caller
  @param guint active Item set to active
 */
void chess_human_menu_cb(GtkWidget *widget, gpointer data, guint active);

/**
  Callback for chess opponent selection change

  @param widget Caller widget
  @param data Extra data given by the caller
 */
void chess_opponent_cb(GtkWidget *widget, gpointer data);

/**
  Callback for chess opponent selection change from the menu

  @param widget Caller widget
  @param data Extra data given by the caller
  @param guint active Item set to active
 */
void chess_opponent_menu_cb(GtkWidget *widget, gpointer data, guint active);

/**
  Callback for mahjong board selection change

  @param widget Caller widget
  @param data Extra data given by the caller
 */
void mahjong_board_cb(GtkWidget *widget, gpointer data);

/**
  Callback for mahjong board selection from the menu

  @param widget Caller widget
  @param data Extra data given by the caller
  @param guint active Item set to active
 */
void mahjong_board_menu_cb(GtkWidget *widget, gpointer data, guint active);

/**
  Callback for LMarbles difficulty selection change

  @param widget Caller widget
  @param data Extra data given by the caller
 */
void lmarbles_difficulty_cb(GtkWidget *widget, gpointer data);

/**
  Callback for LMarbles difficulty selection from the menu

  @param widget Caller widget
  @param data Extra data given by the caller
  @param guint active Item set to active
 */
void lmarbles_difficulty_menu_cb(GtkWidget *widget, gpointer data,
  guint active);

/**
  Callback for sound settings change

  @param widget Caller widget
  @param data Extra data given by the caller
 */
void game_sound_cb(GtkWidget *widget, gpointer data);

/**
  Callback for show legal moves settings change

  @param widget Caller widget
  @param data Extra data given by the caller
 */
void game_moves_cb(GtkWidget *widget, gpointer data);

/**
  Callback for sound change from the menu

  @param widget Caller widget
  @param data Extra data given by the caller
 */
void game_menu_sound_cb(GtkWidget *widget, gpointer data);

/**
  Callback for show legal moves change from the menu

  @param widget Caller widget
  @param data Extra data given by the caller
 */
void game_menu_moves_cb(GtkWidget *widget, gpointer data);

/**
  Callback for quitting game

  @param widget Caller widget
  @param data Extra data given by the caller
 */
gboolean game_quit_cb(GtkWidget *widget, gpointer data);

/**
 Callback for losing topmost status.

 @param widget The widget getting the signal.
 @param data Data associated to the signal.
*/
void game_untop_cb(GtkWidget *widget, gpointer data);

/**
 Callback for acquiring topmost status.

 @param widget The widget getting the signal.
 @param data Data associated to the signal.
*/
void game_top_cb(GtkWidget *widget, gpointer data);

/**
  Get settings from GConf.

  @param app_ui_data AppUIData structure
 */
void get_settings(AppUIData *app_ui_data);

/**
  Set settings to GConf.

  @param app_ui_data AppUIData structure
 */
void set_settings(AppUIData *app_ui_data);

/**
  Callback for play game

  @param widget Caller widget
  @param data Extra data given by the caller
 */
void game_play_cb(GtkWidget *widget, gpointer data);

/**
  Callback for continue game

  @param widget Caller widget
  @param data Extra data given by the caller
 */
void game_continue_cb(GtkWidget *widget, gpointer data);

/**
  Callback for restart game

  @param widget Caller widget
  @param data Extra data given by the caller
 */
void game_restart_cb(GtkWidget *widget, gpointer data);

/**
  Callback for reset game

  @param widget Caller widget
  @param data Extra data given by the caller
 */
void game_reset_cb(GtkWidget *widget, gpointer data);

/**
  Callback for loading recent accessed game

  @param widget Caller widget
  @param num Number of recent game
  @param data Extra data given by the caller
 */
void game_load_recent_cb(GtkWidget *widget, int num, gpointer data);

/**
  Callback for load game

  @param widget Caller widget
  @param data Extra data given by the caller
 */
void game_load_cb(GtkWidget *widget, gpointer data);

/**
  Callback for save game

  @param widget Caller widget
  @param data Extra data given by the caller
 */
void game_save_cb(GtkWidget *widget, gpointer data);

/**
  Callback for save game as

  @param widget Caller widget
  @param data Extra data given by the caller
 */
void game_save_as_cb(GtkWidget *widget, gpointer data);

/**
 Shows help for the current game

 @param widget Caller widget
 @param data Extra data given by the caller
 @return Nothing
*/
void game_help_cb(GtkWidget *widget, gpointer data);

/**
  Shows mahjong high scores

  @param widget Caller widget
  @param data Extra data given by the caller
 */
void mahjongg_scores_cb(GtkWidget* w, gpointer data);

/**
  Change current game to Chess

  @param widget Caller widget
  @param data Extra data given by the caller
 */
void chess_change_cb(GtkWidget *widget, gpointer data);

/**
  Change current game to Mahjong

  @param widget Caller widget
  @param data Extra data given by the caller
 */
void mahjong_change_cb(GtkWidget *widget, gpointer data);

/**
  Change current game to LMarbles

  @param widget Caller widget
  @param data Extra data given by the caller
 */
void lmarbles_change_cb(GtkWidget *widget, gpointer data);

/**
  Set menu item Restart sensitivity.

  @param app_ui_data AppUIData structure
  @param data Extra data given by the caller
 */
void menu_set_restart_dimmed( AppUIData *app_ui_data, gboolean mode );

/**
 Handle key press events.

 @param widget Widget that received the event.
 @param event The event that occurred.
 @param data Pointer to the AppUIData.
 @return TRUE if handled, FALSE otherwise.
*/
gboolean key_press(GtkWidget *widget, GdkEventKey *event, gpointer data);

void startup_close( GtkWidget *widget, gpointer data);

/**
	Initializes callbacks module.
	Stores pointer to app ui data.
	
	@param app_ui_data Application UI data structure
*/
void cb_init(AppUIData * app_ui_data);

/**
	Handles insensitive menu press events.
	Shows given message in an infoprint.
	
	@param widget widget whose callback this is
	@param message message for infoprint
*/
void on_insensitive_menu_press(GtkWidget * widget, gchar * message);

/**
  Shows inforprint "Saved"/sfil_ib_saved (WID INF259)
 */
void show_infoprint(gchar *msg);

/**
    Handles delete event.
    
    @param widget Widget whose callback this is
    @return FALSE if user cancelled close; TRUE otherwise
*/
gboolean on_delete_event( GtkWidget *widget, gpointer data);

/**
    Clean up data and quit.
    
    @param widget Widget whose callback this is
*/
void game_clean_up_and_quit( GtkWidget *widget, gpointer data);

/**
    Monitor game open file.
    
    @param  handle The handle of the monitor that created the event
    @param  monitor_uri The URI of the monitor that was triggered
    @param  info_uri The URI of the actual file this event is concerned with
    @param  event_type What happened to info_uri
    @param  user_data User data
*/
void chess_saved_file_monitor( GnomeVFSMonitorHandle *handle,
			const gchar *monitor_uri,
			const gchar *info_uri,
			GnomeVFSMonitorEventType event_type,
			gpointer user_data);

/**
    Handle button press.
    
    @param dialog The object which received the signal
    @param button The response ID, indicate that which button was press
    @param user_data User data set when the signal handler was connected
*/
void saving_dialog_cb(GtkDialog *dialog, gint button, gpointer user_data);

/**
    Handle volume unmounted.
    
    @param vfsvolumemonitor The object which received the signal
    @param volume The volume to look for
    @param user_data User data set when the signal handler was connected
*/
void volume_unmounted_cb(GnomeVFSVolumeMonitor *vfsvolumemonitor,
  GnomeVFSVolume *volume, gpointer user_data);
  
#endif
