/**
    @file state_save.c

    Application state saving.

    Copyright (c) 2004, 2005 Nokia Corporation.
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/

#include <glib.h>
#include "state_save.h"
#include "startup_gamemanager.h"
#include "settings.h"

#ifdef PATH_MAX
  #define MAX_PATH_LEN PATH_MAX
#else
  #define MAX_PATH_LEN 1024
#endif

typedef struct
{
  gchar previous_folder[MAX_PATH_LEN];
  guint32 game_type;
  guint32 game_state;
} StateData;

extern GameType game_type;
extern GameState game_state;

void save_state(gpointer data)
{
  AppData *app_data = (AppData *)data;
  StateData statedata;
  osso_state_t state;

  memset(&statedata, 0, sizeof(statedata));

  state.state_size = sizeof(statedata);
  state.state_data = (gpointer)&statedata;

  if (app_data->app_ui_data->chess_save_folder != NULL) {
    if (g_strlcpy(statedata.previous_folder,
       app_data->app_ui_data->chess_save_folder, MAX_PATH_LEN)
       >= MAX_PATH_LEN)
    {
      gchar *temp = g_strrstr(statedata.previous_folder, "/");
      *temp = '\0';
    }
  }

  statedata.game_type = game_type;
  statedata.game_state = game_state;

  osso_state_write(app_data->app_osso_data->osso, &state);
}

void read_state(gpointer data)
{
  AppData *app_data = (AppData *)data;
  StateData statedata;
  osso_state_t state;
  osso_return_t ret;

  memset(&statedata, 0, sizeof(statedata));

  state.state_size = sizeof(statedata);
  state.state_data = (gpointer)&statedata;
  
  ret = osso_state_read(app_data->app_osso_data->osso, &state);
  if (ret != OSSO_OK)
    return;
  if (!statedata.game_type)
    return;

  game_type = statedata.game_type;
  //game_state = statedata.game_state;

  app_data->app_ui_data->chess_save_folder =
    g_strdup(statedata.previous_folder);
}

void clear_state(gpointer data)
{
  AppData *app_data = (AppData *)data;
  StateData statedata;
  osso_state_t state;

  memset(&statedata, 0, sizeof(statedata));

  state.state_size = sizeof(statedata);
  state.state_data = &statedata;

  osso_state_write(app_data->app_osso_data->osso, &state);
}
