/**
    @file startup_communication.c

    Implements Communication module.

    Copyright (c) 2004, 2005 Nokia Corporation.
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/

#include "startup_communication.h"

gint handle_game_message(const gchar *method, GArray *arguments,
  gpointer data, osso_rpc_t *retval)
{
  g_assert(method);
  osso_log (LOG_DEBUG, "%s\n", __FUNCTION__);
  osso_rpc_t val = g_array_index(arguments, osso_rpc_t, (guint)0);

  /*
  if (val.type==DBUS_TYPE_INT32) {
    if (val.value.i>gt_none && val.value.i<=gt_lmarbles)
       if (get_game_type()==gt_none) {
         osso_log(LOG_DEBUG,"Got new game type %d, switching to it.\n",
           val.value.i);
         assign_game_type(val.value.i);
         ui_create_main_window(get_app_data());
       }
  }
  */

  osso_log(LOG_DEBUG,"Got DBUS method: %s\n",method);
  
  /* Handle pause method */
  if (g_ascii_strcasecmp(method,GAME_PAUSE_METHOD)==0) {
    g_assert(retval);
    
    get_app_data()->app_ui_data->window_front_needed=TRUE;
    if (check_escape_timeout(TRUE)) {      
      /* Quit application if user presses long ESC from game */    
      game_clean_up_and_quit(NULL, get_app_data()->app_ui_data);
    } else {
      /* Update state & UI */
      game_state_changed(gs_paused);
    }
    
    retval->type=DBUS_TYPE_BOOLEAN;
    retval->value.b=TRUE;
    return OSSO_OK;
  }
  /* Handle home method */
  if (g_ascii_strcasecmp(method,GAME_HOME_METHOD)==0) {
    g_assert(retval);
	  gtk_window_iconify(get_app_data()->app_ui_data->app);

    if (check_escape_timeout(TRUE)) {      
      /* Quit application if user presses long ESC from game */    
      game_clean_up_and_quit(NULL, get_app_data()->app_ui_data);
    } else {
      /* Update state & UI */
      game_state_changed(gs_paused);
    }
    
    retval->type=DBUS_TYPE_BOOLEAN;
    retval->value.b=TRUE;
    return OSSO_OK;
  }
  /* Handle end method */
  else if (g_ascii_strcasecmp(method,GAME_END_METHOD)==0) {
    g_assert(retval);

    /* Update state & UI */
    game_state_changed(gs_closed);

    retval->type=DBUS_TYPE_BOOLEAN;
    retval->value.b=TRUE;
    return OSSO_OK;
  }
  /* Handle mime open message */
  else if (g_ascii_strcasecmp(method, GAME_MIME_OPEN) == 0) {
    if ((val.type == DBUS_TYPE_STRING)
        && (val.value.s != NULL)) {
      game_mime_open((gchar *)val.value.s);
              
      /* success*/
      retval->type=DBUS_TYPE_BOOLEAN;
      retval->value.b=TRUE;
      return OSSO_OK;
    } else {
      retval->type=DBUS_TYPE_BOOLEAN;
      retval->value.b=FALSE;
    }
    
    return OSSO_OK;    
  }
  else {
    osso_log(LOG_ERR, "Unknown DBUS method: %s\n", method);

    retval->type=DBUS_TYPE_BOOLEAN;
    retval->value.b=FALSE;
  }

  return OSSO_ERROR;
}

gboolean set_game_state(const guint state, osso_rpc_t *retval)
{
  osso_return_t ret;
  GString *method=NULL,*service=NULL,*path=NULL,*iface=NULL;

  osso_log(LOG_DEBUG,"Setting state: %d\n",state);
  osso_log(LOG_DEBUG,"State: %d\n",get_game_state());

  /* Select method */
  switch(state) {
    case GAME_RUN:
      /* Start new game */
      method = g_string_new(GAME_RUN_METHOD);
      break;
    case GAME_CONTINUE:
      /* Resume game */
      method = g_string_new(GAME_CONTINUE_METHOD);
      break;
    case GAME_RESTART:
      /* Restart ongoing game */
      method = g_string_new(GAME_RESTART_METHOD);
      break;
    case GAME_CLOSE:
      /* Close ongoing game */
      method = g_string_new(GAME_CLOSE_METHOD);

      /* Do not send any messages, just assume game is not running. */
      //return TRUE;
      break;
    case GAME_LOAD:
      /* Load game */
      method = g_string_new(GAME_LOAD_METHOD);
      break;
    case GAME_SAVE:
      /* Save ongoing game */
      method = g_string_new(GAME_SAVE_METHOD);
      break;
    default:
      return FALSE;
  }

  g_assert(method);
/*  g_print("Set game state\n");
  g_printf("Service: %s\n",game_get_service());
  g_printf("Object path: %s\n",game_get_object_path());
  g_printf("Iface: %s\n",game_get_iface());
  g_printf("Method: %s\n",method->str);*/
	service=game_get_service();
	path=game_get_object_path();
	iface=game_get_iface();
	g_assert(service);
	g_assert(path);
	g_assert(iface);

  /* Send message */
  ret = send_dbus_message(
    service->str,
    path->str,
    iface->str,
    method->str,
    NULL,
    retval
  );
	g_string_free(service,TRUE);
	g_string_free(path,TRUE);
	g_string_free(iface,TRUE);

  if (method != NULL)
    g_string_free(method, TRUE);

  if (ret == OSSO_OK) 
    return TRUE;
  
  return FALSE;
}

gboolean set_game_state_async(const guint state)
{
  osso_return_t ret;
  GString *method=NULL,*service=NULL,*path=NULL,*iface=NULL;;
  AppData *ad=get_app_data();
	osso_log(LOG_DEBUG,"%d\n",__FUNCTION__);
  osso_log(LOG_DEBUG,"Setting state: %d\n",state);
  osso_log(LOG_DEBUG,"State: %d\n",get_game_state());

  /* Select method */
  switch(state) {
    case GAME_RUN:
      /* Start new game */
      method = g_string_new(GAME_RUN_METHOD);
      break;
    case GAME_CONTINUE:
      /* Resume game */
      method = g_string_new(GAME_CONTINUE_METHOD);
      break;
    case GAME_RESTART:
      /* Restart ongoing game */
      method = g_string_new(GAME_RESTART_METHOD);
      break;
    case GAME_CLOSE:
      /* Close ongoing game */
      method = g_string_new(GAME_CLOSE_METHOD);
      break;
    case GAME_LOAD:
      /* Load game */
      method = g_string_new(GAME_LOAD_METHOD);
      break;
    case GAME_SAVE:
      /* Save ongoing game */
      method = g_string_new(GAME_SAVE_METHOD);
      break;
    default:
      return FALSE;
  }

  g_assert(method);
  /*g_print("Set game state async\n");
  g_printf("Service: %s\n",game_get_service());
  g_printf("Object path: %s\n",game_get_object_path());
  g_printf("Iface: %s\n",game_get_iface());
  g_printf("Method: %s\n",method->str);*/
  /*Setting the buttons unsensitive, while it makes the command*/
  dimm_everything(ad);
  /*if (GTK_WIDGET_VISIBLE(ad->app_ui_data->play_button))
  {
	gtk_widget_set_sensitive(ad->app_ui_data->play_button,FALSE);
  } 
  if (GTK_WIDGET_VISIBLE(ad->app_ui_data->continue_button))
  {
	gtk_widget_set_sensitive(ad->app_ui_data->continue_button,FALSE);
  } 
  if (GTK_WIDGET_VISIBLE(ad->app_ui_data->restart_button))
  {
	gtk_widget_set_sensitive(ad->app_ui_data->restart_button,FALSE);
  }*/
	service=game_get_service();
	path=game_get_object_path();
	iface=game_get_iface();
	g_assert(service);
	g_assert(path);
	g_assert(iface);

  /* Send message */
  ret = send_dbus_message_async(
    service->str,
    path->str,
    iface->str,
    method->str,
    NULL,
    (gpointer)get_app_data()
  );

  if (method != NULL)
    g_string_free(method, TRUE);
	g_string_free(service,TRUE);
	g_string_free(path,TRUE);
	g_string_free(iface,TRUE);

  if (ret == OSSO_OK) 
    return TRUE;

  return FALSE;
}

gboolean check_escape_timeout(gboolean reset_key)
{
  gchar *settings_escape_timeout_key = NULL;
  gboolean is_escape_timeout = FALSE;

  switch (get_game_type()) {
    case gt_chess:
      is_escape_timeout = settings_get_bool(SETTINGS_CHESS_ESCAPE_TIMEOUT);
      settings_escape_timeout_key = g_strdup(SETTINGS_CHESS_ESCAPE_TIMEOUT);
      break;
    case gt_mahjong:
      is_escape_timeout = settings_get_bool(SETTINGS_MAHJONG_ESCAPE_TIMEOUT);
      settings_escape_timeout_key = g_strdup(SETTINGS_MAHJONG_ESCAPE_TIMEOUT);
      break;
    case gt_lmarbles:
      is_escape_timeout = settings_get_bool(SETTINGS_LMARBLES_ESCAPE_TIMEOUT);
      settings_escape_timeout_key = g_strdup(SETTINGS_LMARBLES_ESCAPE_TIMEOUT);
      break;
    case gt_none:
      break;
  }
 
  if (reset_key && settings_escape_timeout_key)
    settings_set_bool(settings_escape_timeout_key, FALSE);
  
  if (settings_escape_timeout_key)
    g_free(settings_escape_timeout_key);
    
  return is_escape_timeout;
}
