/**
    @file appdata.h

    Data structures for the whole application.

    Copyright (c) 2004, 2005 Nokia Corporation.
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/

/* OSSO */
#include <libosso.h>

/* GTK */
#include <gtk/gtk.h>

/* Hildon */
#include <hildon-widgets/hildon-app.h>
#include <hildon-widgets/hildon-appview.h>

/* GConf */
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

#ifndef APPDATA_H
#define APPDATA_H

#define __(String) dgettext("ke-recv", String)



typedef struct _AppUIData AppUIData;

typedef void   (startup_app_top_cb)          (AppUIData *app,
                                              gpointer    data);
typedef void   (startup_app_state_change_cb) (AppUIData *app,
                                              guint       oldstate,
                                              guint       newstate,
                                              gpointer    data);
typedef struct _StartupConfig StartupConfig;
typedef struct _StartupPlugin        StartupPlugin;


typedef struct _StartupPluginPrivate StartupPluginPrivate;
struct _StartupPluginPrivate {
  GModule *handle;
};

typedef struct _StartupApp        StartupApp;
struct _StartupApp {
  StartupConfig *config;
  osso_context_t *osso;
  guint state;

  startup_app_top_cb *top_cb;
  gpointer top_cb_data;
  startup_app_state_change_cb *state_change_cb;
  gpointer state_change_cb_data;

  const gchar *service;
  const gchar *path;
  const gchar *iface;
};

typedef struct _StartupUI            StartupUI;
struct _StartupUI {
  StartupApp *app;
  StartupPlugin *plugin;
 
  HildonApp *hildon_app;
  HildonAppView *hildon_appview;
  
  GtkItemFactory *item_factory;
  GtkWidget *controls_state_label;
  GtkWidget *play_button;
  GtkWidget *restart_button;
};

typedef struct _GameStartupInfo      GameStartupInfo;
struct _GameStartupInfo {
	StartupUI *ui;
  //AppUIData *ui;
  void (* startup_ui_menu_action_cb) (gpointer   data, 
                                      guint      action, 
                                      GtkWidget *menu_item);
  void (* startup_ui_state_change_cb)(AppUIData *app, 
                                      guint       oldstate,
                                      guint       newstate,
                                      gpointer    data);
};

typedef struct _StartupPluginInfo    StartupPluginInfo;
struct _StartupPluginInfo {
  // FIXME
  
  GtkWidget *  (* load)         (void);
  void         (* unload)       (void);
  void         (* write_config) (void);
  GtkWidget ** (* load_menu)    (guint *); 
  void         (* update_menu)  (void);
  void         (* plugin_cb)    (GtkWidget *menu_item, gpointer cb_data); 
};


/*
  We need this to store some information about the plugin
 */

struct _StartupPlugin {
  StartupPluginInfo *info;
  gpointer data;                /* plugin specific data */

  GameStartupInfo *gs;
  gboolean send_game_close;
  gboolean menu_open_save;

  StartupPluginPrivate *priv;
  const gchar *gettext_package; 
};



typedef struct _StartupConfigPrivate StartupConfigPrivate;
struct _StartupConfigPrivate 
{
  gboolean initialized;
  gchar *current_group;
  GHashTable *hash_group;
  GHashTable *current_hash_entry;
};



struct _StartupConfig 
{
  gchar *file;
  
  StartupConfigPrivate *priv;
};

/*
  Application UI data

  This structure should contain ALL application UI related data, which
  otherwise would be impossible to pass with events to callbacks. It makes
  complicated intercommunication between widgets possible.

  So when you add a widget to ui, put a pointer to it inside this struct.
*/

struct _AppUIData {
  HildonApp *app;
  HildonAppView *main_view;
/*  HildonAppView *the_main_view;
  HildonAppView *chess_view;
  HildonAppView *mahjong_view;
  HildonAppView *lmarbles_view;
  */
  GtkItemFactory *item_factory;
  GtkItemFactory *chess_item_factory;
  GtkItemFactory *mahjong_item_factory;
  GtkItemFactory *lmarbles_item_factory;
  GtkMenu *main_menu_bar;
  GtkWidget *main_toolbar;
  GtkWidget *main_vbox;
  GtkWidget *game_vbox;
  GtkWidget *game_hbox;
  GtkWidget *game_image;
  GtkWidget *controls_hbox;
  GtkWidget *controls_vbox;
  GtkWidget *controls_fixed;
  GtkWidget *controls_state_label;
  GtkWidget *play_button;
  GtkWidget *continue_button;
  GtkWidget *restart_button;
  GtkWidget *quit_button;
  GtkWidget *game_restart_menu;
  GtkWidget *game_play_menu;
  GtkWidget *game_game_menu;
  GtkWidget *game_save_menu;
  GtkWidget *game_saveas_menu;

  /* Chess widgets */
  gboolean skip_box_update;
  GtkWidget *chess_labels_vbox;
  GtkWidget *chess_players_vbox;
  GtkWidget *chess_human_label;
  GtkWidget *chess_human_choice;
  GtkWidget *chess_opponent_label;
  GtkWidget *chess_opponent_choice;
  GtkWidget *chess_checks_vbox;
  GtkWidget *chess_checklabels_vbox;
  GtkWidget *chess_sound_label;
  GtkWidget *chess_sound_check;
  GtkWidget *chess_moves_label;
  GtkWidget *chess_moves_check;
  GtkWidget *chess_recent_menu;

  GSList *chess_recent_items;
  gchar *chess_save_folder;
  gboolean chess_saved;
  gint chess_save_done;	// save action status
  GtkWidget *chess_saving_dialog;

  /* Mahjong widgets */
  GtkWidget *mahjong_labels_vbox;
  GtkWidget *mahjong_selections_vbox;
  GtkWidget *mahjong_high_scores_vbox;
  GtkWidget *mahjong_board_label;
  GtkWidget *mahjong_board_choice;
  GtkWidget *mahjong_sound_label;
  GtkWidget *mahjong_sound_check;
  GtkWidget *mahjong_scores_button;
  GtkWidget *mahjong_tree_model;
  /* LMarbles widgets */
  GtkWidget *lmarbles_difficulty_label;
  GtkWidget *lmarbles_difficulty_choice;
  GtkWidget *lmarbles_sound_label;
  GtkWidget *lmarbles_sound_check;
  
  /* Menu Items */
  GtkWidget *play_item;
  GtkWidget *open_item;

/*No free memory dialog*/
  GtkWidget *nomem_dialog;
  
  gchar *mmc_uri;
  gboolean is_mmc;
  StartupConfig *indt_startup_config;
  startup_app_top_cb *top_cb;
  gpointer top_cb_data;
  startup_app_state_change_cb *state_change_cb;
  gpointer state_change_cb_data;
  StartupPlugin *plugin;
  const gchar *service;
  const gchar *path;
  const gchar *iface;
  gchar *game_title;
  guint timeout;
  gboolean async_command_sending;
  gboolean low_memory;
  gboolean got_pause;
  gboolean window_front_needed;
  guint timeouts;
};

typedef struct _AppOSSOData AppOSSOData;
struct _AppOSSOData {
  osso_context_t *osso;
};

typedef struct _AppGConfData AppGConfData;
struct _AppGConfData {
  GConfClient *gc_client;
};

/*
  Application data structure. Pointer to this is passed eg. with UI
  event callbacks.
*/
typedef struct _AppData AppData;
struct _AppData {
  AppUIData *app_ui_data;
  AppOSSOData *app_osso_data;
  AppGConfData *app_gconf_data;
};

#endif /* APPDATA_H */
