/**
    @file chess_core.cc

    Implements ChessCore

    Copyright (c) 2004, 2005 Nokia Corporation.
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/

#include "chess_core.hh"
#include "sound.h"
#include "state_save.h"


void chess_home(GtkWidget *widget, gpointer data)
{
  (void)widget;

  AppData *app_data = get_app_data();
  if (app_data->app_ui_data->dialog)
  {
    gtk_widget_hide(GTK_WIDGET(app_data->app_ui_data->dialog));
    gtk_widget_unref(GTK_WIDGET(app_data->app_ui_data->dialog));
  }
  

  /* Ensure engine is paused */
  Engine *chess_engine = get_chess_engine();

  if (chess_engine) {
    chess_engine->force_move();
  
    /* Check for proper thinking time */
    if (chess_engine->enough_time()==FALSE) {
      /* Undo engine move */
      //chess_engine->undo();

      chess_engine->set_stopped(TRUE);
    }
  }

  if (app_data) {
    /* Hide main window */
    ui_view_main_window(app_data, FALSE);
    gtk_main_iteration();

    /* Set game paused, send message to start up screen */
    //set_game_state(GAME_HOME_METHOD);

    /* Hide window */
    //gtk_window_unfullscreen( ((AppData*)data)->window );
    if (data) {
      gtk_widget_hide( GTK_WIDGET( ((AppUIData*)data)->window ) );
    }

    save_state(app_data);
    sound_deinit(app_data->app_sound_data);
  }

  app_remove_timeout();
  gtk_main_quit();
}



void chess_pause(GtkWidget *widget, gpointer data)
{
  (void)widget;

  AppData *app_data = get_app_data();
  /* Ensure engine is paused */
  Engine *chess_engine = get_chess_engine();

  if (chess_engine) {
    chess_engine->force_move();
    /* Check for proper thinking time */
    if (chess_engine->enough_time()==FALSE) {
      /* Undo engine move */
      //chess_engine->undo();
      chess_engine->set_stopped(TRUE);
    }
  }

  if (app_data) {
    /* Hide main window */
    ui_view_main_window(app_data, FALSE);
    gtk_main_iteration();

    /* Set game paused, send message to start up screen */
    set_game_state(GAME_PAUSE_METHOD);
    /* Hide window */
    //gtk_window_unfullscreen( ((AppData*)data)->window );
    if (data) {
      gtk_widget_hide( GTK_WIDGET( ((AppUIData*)data)->window ) );
    }
    save_state(app_data);
    sound_deinit(app_data->app_sound_data);
  }
  app_remove_timeout();
  gtk_main_quit();
}

void chess_cursor_left(void)
{
  AppData *app_data = get_app_data();
  if (app_data && app_data->app_ui_data && app_data->app_ui_data->game) {
    app_data->app_ui_data->game->Move_Cursor_Left();
  }
}
  
void chess_cursor_right(void) {
  AppData *app_data = get_app_data();
  if (app_data && app_data->app_ui_data && app_data->app_ui_data->game) {
    app_data->app_ui_data->game->Move_Cursor_Right();
  }
}
void chess_cursor_up(void) {
  AppData *app_data = get_app_data();
  if (app_data && app_data->app_ui_data && app_data->app_ui_data->game) {
    app_data->app_ui_data->game->Move_Cursor_Up();
  }
}
void chess_cursor_down(void) {
  AppData *app_data = get_app_data();
  if (app_data && app_data->app_ui_data && app_data->app_ui_data->game) {
    app_data->app_ui_data->game->Move_Cursor_Down();
  }
}
void chess_cursor_do(void) {
  AppData *app_data = get_app_data();
  if (app_data && app_data->app_ui_data && app_data->app_ui_data->game) {
    app_data->app_ui_data->game->Cursor_Action();
  }
}

void chess_close(gboolean send_game_state)
{
  if (send_game_state)
    set_game_state(GAME_CLOSE_METHOD);
    
  if (get_app_data())
  {
    sound_deinit(get_app_data()->app_sound_data);
  }
  
  app_remove_timeout();
  gtk_main_quit();
}

void chess_end(gint result)
{
  AppData *ad = get_app_data();
  /* Show dialog */
  if (ad!=NULL && result!=cr_none) {
    gchar *winner = NULL;
    if (result==cr_white) {
      if ( ad->app_ui_data->opponent_type_human) {
        if (ad->app_ui_data->player_color_white)
        {
        winner = _(CHESS_PLAYER1_NAME);
        }
        else
        {
          winner = _(CHESS_PLAYER2_NAME);
        }
      } else {
        winner = _(CHESS_COMPUTER_NAME);
      }
    } else
    if (result==cr_black) {
      if ( (ad->app_ui_data->opponent_type_human)&&(ad->app_ui_data->player_color_white) ) {
        winner = _(CHESS_PLAYER2_NAME);
      } else
      if (!ad->app_ui_data->player_color_white ) {
        winner = _(CHESS_PLAYER1_NAME);
      } else {
        winner = _(CHESS_COMPUTER_NAME);
      }
    }
    /* SOUND_MATE is played with check mate information banner already */ 
    /* sound_play(ad->app_sound_data, SOUND_MATE); */
    ui_show_end_dialog(ad->app_ui_data, winner);
  }

  /* Set game ended, send message to start up screen */
  //set_game_state(GAME_END_METHOD);
  //chess_close();
}

/* Show check infoprint */
void chess_check()
{
  AppData *ad = get_app_data();

  if (ad != NULL)
    ui_show_check_infoprint(ad->app_ui_data);
}

/* Show check mate infoprint */
void chess_check_mate()
{
  AppData *ad = get_app_data();
  
  if (ad != NULL)
    ui_show_check_mate_infoprint(ad->app_ui_data);
}
