#ifndef DATA_INCLUDED
#define DATA_INCLUDED

/* Allocate an object dynamically.  Equivalent of standard C++
 * new()/delete().  See etc/DATA
 */

#include "object.hh"
#include "inline.hh"

#ifndef NDEBUG

#include <typeinfo>

void Data_On_Alloc(const char *type,
		   void *pointer,
		   const char *file);

void Data_On_Free(void *pointer, 
		  const char *file);

#else /* NDEBUG */

#define Data_On_Alloc(s, p, f) (void)(0)
#define Data_On_Free(p, f)     (void)(0)

#endif /* NDEBUG */


/* Common definitions */
#define Data_Alloc(Type, args...)				\
({								\
	Type *data_alloc_object;				\
	try							\
	{							\
		data_alloc_object= new Type(args);		\
		assert (data_alloc_object != NULL); 		\
		Data_On_Alloc(typeid(Type).name(),              \
                              data_alloc_object, __FILE__);	\
	}							\
	catch (...)						\
	{							\
		data_alloc_object= NULL;			\
	}							\
	data_alloc_object;					\
})

#define Data_Free(object)          \
((void)((((object) != NULL) ? (Data_On_Free((object), __FILE__),1) : 0), \
 ({delete object;8;})==0))


#endif /* ! DATA_INCLUDED */
