/*
 * This file is part of osso-backup
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Andrey Kochanov <andrey.kochanov@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef OB_ARCHIVER_TEST_H_
#define OB_ARCHIVER_TEST_H_

#include <glib.h>
#include <libgnomevfs/gnome-vfs.h>

#include "ob-archiver.h"

G_BEGIN_DECLS

#define OB_TYPE_ARCHIVER_TEST            (ob_archiver_test_get_type ())
#define OB_ARCHIVER_TEST(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
					OB_TYPE_ARCHIVER_TEST, ObArchiverTest))
#define OB_ARCHIVER_TEST_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), \
					OB_TYPE_ARCHIVER_TEST, ObArchiverTestClass))
#define OB_IS_ARCHIVER_TEST(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
					OB_TYPE_ARCHIVER_TEST))
#define OB_IS_ARCHIVER_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
					OB_TYPE_ARCHIVER_TEST))
#define OB_ARCHIVER_TEST_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
					OB_TYPE_ARCHIVER_TEST, ObArchiverTestClass))


typedef struct _ObArchiverTest      ObArchiverTest;
typedef struct _ObArchiverTestClass ObArchiverTestClass;

struct _ObArchiverTest {
	ObArchiver        parent;
};

struct _ObArchiverTestClass {
	ObArchiverClass   parent_class;
};


GType       ob_archiver_test_get_type (void) G_GNUC_CONST;
ObArchiver *ob_archiver_test_new      (gboolean simulate_errors,
				       gboolean simulate_conflicts);


G_BEGIN_DECLS

#endif /* OB_ARCHIVER_TEST_H_ */
