/*
 * This file is part of osso-backup
 *
 * Copyright (C) 2005-2006 Nokia Corporation.
 *
 * Contact: Andrey Kochanov <andrey.kochanov@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef OB_VFS_UTILS_H_
#define OB_VFS_UTILS_H_

#include <time.h>
#include <libgnomevfs/gnome-vfs.h>

G_BEGIN_DECLS

typedef gboolean (*ObRmDirCancelCb) (gpointer data);

GnomeVFSResult ob_vfs_utils_uri_set_timestamp_and_mode (GnomeVFSURI       *uri,
							time_t             stamp,
							mode_t             mode);
GnomeVFSResult ob_vfs_utils_uri_set_mode               (GnomeVFSURI       *uri,
							mode_t             mode);
GnomeVFSResult ob_vfs_utils_uri_set_timestamp          (GnomeVFSURI       *uri,
							time_t             stamp);
GnomeVFSResult ob_vfs_utils_uri_get_timestamp          (GnomeVFSURI       *uri,
							time_t            *stamp);
GnomeVFSResult ob_vfs_utils_uri_get_file_type          (GnomeVFSURI       *uri,
							GnomeVFSFileType  *type);
GnomeVFSURI   *ob_vfs_utils_create_unique_dir          (GnomeVFSURI       *uri,
							guint              mode);
GnomeVFSURI *  ob_vfs_utils_create_unique_file         (GnomeVFSHandle   **handle,
							GnomeVFSURI       *uri,
							guint              mode);
GnomeVFSResult ob_vfs_utils_move_to_unique_uri         (GnomeVFSURI       *src_uri,
							GnomeVFSURI       *dest_uri,
							GnomeVFSURI      **dest_uri_p);
GnomeVFSResult ob_vfs_utils_create_temp_file           (GnomeVFSHandle   **handle,
							GnomeVFSURI       *dir_uri,
							guint              mode,
							GnomeVFSURI      **file_uri);
void           ob_vfs_utils_count_files                (GList             *uris,
							int               *files,
							GnomeVFSFileSize  *size);
GnomeVFSResult ob_vfs_utils_remove_directory           (GnomeVFSURI       *uri,
							ObRmDirCancelCb    cancel_func,
							gpointer           cancel_data);
GnomeVFSResult ob_vfs_utils_write                      (GnomeVFSHandle    *handle,
							gconstpointer      buffer,
							GnomeVFSFileSize   bytes);
GHashTable *   ob_vfs_utils_get_file_entries           (GList             *uris);
GSList *       ob_vfs_utils_get_file_entries_filtered  (GList             *include_uris,
							GList             *exclude_uris);
void           ob_vfs_utils_free_file_entries          (GSList            *entries);

G_END_DECLS

#endif /* OB_VFS_UTILS_H_ */



