/*
 * This file is part of osso-backup
 *
 * Copyright (C) 2005-2006 Nokia Corporation.
 *
 * Contact: Andrey Kochanov <andrey.kochanov@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef OB_UTILS_H_
#define OB_UTILS_H_

#include <glib.h>
#include <time.h>
#include <gtk/gtkdialog.h>
#include <openssl/aes.h>
#include <libosso.h>
#include <libogs/ogs-file-system.h>
#ifndef DBUS_API_SUBJECT_TO_CHANGE
#define DBUS_API_SUBJECT_TO_CHANGE
#endif
#include <dbus/dbus.h>

#include "ob-types.h"

G_BEGIN_DECLS

void            ob_utils_set_osso_context          (osso_context_t  *context);
osso_context_t *ob_utils_get_osso_context          (void);
DBusConnection *ob_utils_get_dbus_connection       (void);
void            ob_utils_set_file_system           (OgsFileSystem   *fs);
OgsFileSystem * ob_utils_get_file_system           (void);
void            ob_utils_hexdump                   (guchar          *data);
guchar *        ob_utils_get_128_bits_hash         (const char      *password);
void            ob_utils_xor_16_bytes              (guchar          *a,
						    const guchar    *b);
guchar *        ob_utils_create_random_16_bytes    (void);
gchar *         ob_utils_get_timestamp_string      (time_t           t);
gchar *         ob_utils_get_time_string           (time_t           t);
gchar *         ob_utils_get_date_string           (time_t           t);
gboolean        ob_utils_get_last_backup           (char           **name,
						    char           **memory_card_name,
						    time_t          *timestamp);
gboolean        ob_utils_set_last_backup           (const char      *name,
						    const char      *memory_card_name,
						    time_t           timestamp);
void            ob_utils_clear_container           (GtkContainer    *container);
void            ob_utils_show_help                 (const gchar     *help_id,
						    gboolean         in_dialog);
void            ob_utils_setup_dialog_help         (GtkDialog       *dialog,
						    const gchar     *help_id);
void            ob_utils_decrypt_data              (AES_KEY         *aes,
						    guchar          *xor,
						    guchar          *data,
						    gsize            num_bytes);
gboolean        ob_utils_check_password            (const char      *path,
						    const char      *password);
const char *    ob_utils_get_device_version        (void);
char *          ob_utils_parse_path                (const char      *str);
void            ob_utils_send_reboot_message       (void);
void            ob_utils_kill_apps                 (void);
gboolean        ob_utils_get_flight_mode           (void);
void            ob_utils_set_flight_mode           (gboolean         flight);
char *          ob_utils_get_install_home          (void);

gchar *         ob_utils_get_size                  (guint bytes);
gboolean        ob_utils_get_is_usb_inserted       (void);

G_END_DECLS

#endif /* OB_UTILS_H */
