/*
 * This file is part of osso-backup
 *
 * Copyright (C) 2005-2006 Nokia Corporation.
 *
 * Contact: Andrey Kochanov <andrey.kochanov@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef OB_TYPES_H_
#define OB_TYPES_H_

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

typedef enum {
	OB_CATEGORY_EMAILS    = 1 << 0,
	OB_CATEGORY_CONTACTS  = 1 << 1,
	OB_CATEGORY_DOCUMENTS = 1 << 2,
	OB_CATEGORY_MEDIA     = 1 << 3, /* images, audio, video */
	OB_CATEGORY_BOOKMARKS = 1 << 4,
	OB_CATEGORY_SETTINGS  = 1 << 5, /* not part of mime/category mapping */
	OB_CATEGORY_OTHER     = 1 << 6, /* files that don't fit in any category */
	OB_CATEGORY_ALL       = (1 << 7) - 1
} ObCategory;

/* Do we need those outside of this file? */
enum {
	OB_CATEGORY_INDEX_EMAILS,
	OB_CATEGORY_INDEX_CONTACTS,
	OB_CATEGORY_INDEX_DOCUMENTS,
	OB_CATEGORY_INDEX_MEDIA,
	OB_CATEGORY_INDEX_BOOKMARKS,
	OB_CATEGORY_INDEX_SETTINGS,
	OB_CATEGORY_INDEX_OTHER,

	OB_NUM_CATEGORIES
};

typedef enum {
	/* Ready to start an operation. */
	OB_STATE_READY,

	/* BACKUP operation in progress. */
	OB_STATE_BACKUP,

	/* Restore operation in progress. */
	OB_STATE_RESTORE,

	/* Restore operation in progress, waiting for user response. */
	OB_STATE_RESTORE_CONFLICT
} ObState;


/* The different types of progress events. */
typedef enum {
	OB_PROGRESS_TYPE_NORMAL,
	OB_PROGRESS_TYPE_FINALIZING
} ObProgressType;


/* The different types of conflicts. */
typedef enum {
	OB_CONFLICT_TYPE_FILE_FILE, /* File is in way of file. */
	OB_CONFLICT_TYPE_FILE_DIR,  /* File is in way of dir. */
	OB_CONFLICT_TYPE_DIR_FILE   /* Dir is in way of file. */
} ObConflictType;


/* The conflict responses. */
typedef enum {
	OB_CONFLICT_RESPONSE_NONE = 0,
	OB_CONFLICT_RESPONSE_YES,
	OB_CONFLICT_RESPONSE_YES_ALL,
	OB_CONFLICT_RESPONSE_NO,
	OB_CONFLICT_RESPONSE_CANCEL
} ObConflictResponse;


#define OB_TYPE_CONFLICT_TYPE (ob_conflict_type_get_type())
GType ob_conflict_type_get_type (void);


G_END_DECLS

#endif /* OB_TYPES_H_ */





