/*
 * This file is part of osso-backup
 *
 * Copyright (C) 2005-2006 Nokia Corporation.
 *
 * Contact: Andrey Kochanov <andrey.kochanov@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef OB_SELECTIVE_DIALOG_H_
#define OB_SELECTIVE_DIALOG_H_

#include <gtk/gtkwindow.h>
#include "ob-ui.h"
#include "ob-backend.h"

G_BEGIN_DECLS

typedef struct _ObSelectiveDialog ObSelectiveDialog;

ObSelectiveDialog *
ob_selective_dialog_new                        (GtkWindow         *parent,
						ObUiOperation      operation,
						ObBackend         *backend,
						ObMemoryCardType   type);
int         ob_selective_dialog_run            (ObSelectiveDialog *dialog);
void     
ob_selective_dialog_set_available_categories   (ObSelectiveDialog *dialog,
						gint               categories);
gint        ob_selective_dialog_get_categories (ObSelectiveDialog *dialog);
gboolean    ob_selective_dialog_get_protect    (ObSelectiveDialog *dialog);
void        ob_selective_dialog_destroy        (ObSelectiveDialog *dialog);

G_END_DECLS

#endif /* OB_SELECTIVE_DIALOG_H_ */
