/*
 * This file is part of osso-backup
 *
 * Copyright (C) 2005-2006 Nokia Corporation.
 *
 * Contact: Andrey Kochanov <andrey.kochanov@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef OB_MEMORY_CARD_H_
#define OB_MEMORY_CARD_H_

#include <glib.h>
#include <libgnomevfs/gnome-vfs.h>

G_BEGIN_DECLS

typedef enum {
	OB_MEMORY_CARD_INTERNAL = 1,
	OB_MEMORY_CARD_EXTERNAL
} ObMemoryCardType;

typedef struct _ObMemoryCard ObMemoryCard;

ObMemoryCard * ob_memory_card_new             (GnomeVFSURI      *uri,
					       const char       *name);
ObMemoryCard * ob_memory_card_ref             (ObMemoryCard     *card);
void           ob_memory_card_unref           (ObMemoryCard     *card);
const char *   ob_memory_card_get_name        (ObMemoryCard     *card);
GnomeVFSURI *  ob_memory_card_get_uri         (ObMemoryCard     *card);
GList *        ob_memory_card_get_backups     (ObMemoryCard     *card);
void           ob_memory_card_clear_cache     (ObMemoryCard     *card);
void           ob_memory_card_clear_tmp_files (ObMemoryCard     *card);
GnomeVFSResult ob_memory_card_get_free_space  (ObMemoryCard     *card,
					       GnomeVFSFileSize *size);

G_END_DECLS

#endif /* OB_MEMORY_CARD_H_ */

