/*
 * This file is part of osso-backup
 *
 * Copyright (C) 2005-2006 Nokia Corporation.
 *
 * Contact: Andrey Kochanov <andrey.kochanov@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef OB_EVENT_H_
#define OB_EVENT_H_

#include <time.h>
#include <glib.h>
#include <libgnomevfs/gnome-vfs.h>

#include "ob-types.h"
#include "ob-category.h"

G_BEGIN_DECLS

typedef struct _ObEvent ObEvent;

typedef enum {
	OB_EVENT_PROGRESS,
	OB_EVENT_CONFLICT,
	OB_EVENT_ERROR,
	OB_EVENT_FINISHED,
	OB_EVENT_CANCELLED
} ObEventType;


void        ob_event_free          (ObEvent           *event);
ObEvent *   ob_event_new_progress  (ObProgressType     progress_type,
				    int                files,
				    int                total,
				    int                complete,
				    ObCategory         category);
ObEvent *   ob_event_new_error     (GError            *error);
ObEvent *   ob_event_new_conflict  (ObConflictType     type,
				    GnomeVFSURI       *uri,
				    time_t             old_time,
				    time_t             new_time);
ObEvent *   ob_event_new_finished  (GnomeVFSFileSize   processed_size,
				    int                processed_files);
ObEvent *   ob_event_new_cancelled (void);
ObEventType ob_event_get_type      (ObEvent           *event);
gboolean    ob_event_get_progress  (ObEvent           *event,
				    ObProgressType    *progress_type,
				    int               *files,
				    int               *total,
				    int               *complete,
				    ObCategory        *category);
gboolean    ob_event_get_error     (ObEvent           *event,
				    GError           **error);
gboolean    ob_event_get_conflict  (ObEvent           *event,
				    ObConflictType    *type,
				    GnomeVFSURI      **uri,
				    time_t            *old_time,
				    time_t            *new_time);
gboolean    ob_event_get_finished  (ObEvent           *event,
				    GnomeVFSFileSize  *processed_size,
				    int               *files);

G_END_DECLS

#endif /* OB_EVENT_H_ */



