/*
 * This file is part of osso-backup
 *
 * Copyright (C) 2005-2006 Nokia Corporation.
 *
 * Contact: Andrey Kochanov <andrey.kochanov@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef OB_CATEGORY_H_
#define OB_CATEGORY_H_

#include <libgnomevfs/gnome-vfs.h>
#include <libogs/ogs-file-system.h>
#include "ob-types.h"

G_BEGIN_DECLS


/*
 * FIXME: We maybe should make those structs opaque.
 */

typedef struct {
	GnomeVFSURI      *uri;
	GnomeVFSFileInfo *file_info;
} ObFileEntry;

typedef struct {
	/* Those are lists of ObFileInfo, indexed by ObCategoryIndex enums. */
	GSList *file_entries[OB_NUM_CATEGORIES];
	
	/* Total file size and number of files per category. */
	GnomeVFSFileSize file_size[OB_NUM_CATEGORIES];
	int              num_files[OB_NUM_CATEGORIES];
} ObCategoryFiles;


ObFileEntry *    ob_file_entry_new                    (GnomeVFSURI      *uri,
						       GnomeVFSFileInfo *file_info);
ObFileEntry *    ob_file_entry_dup                    (ObFileEntry      *entry);
void             ob_file_entry_free                   (ObFileEntry      *entry);
void             ob_file_entry_print                  (ObFileEntry      *entry);
void             ob_file_entry_free_list              (GSList           *entries);
ObCategoryFiles *ob_category_files_new                (void);
void             ob_category_files_free               (ObCategoryFiles  *files);
void             ob_category_files_read               (ObCategoryFiles  *files,
						       int               categories);
ObCategory       ob_category_from_index               (int               index);
int              ob_category_to_index                 (ObCategory        category);
ObCategory       ob_category_from_mime_type           (const gchar      *mime_type);
const gchar *    ob_category_to_string                (ObCategory        category);
const gchar *    ob_category_to_non_translated_string (ObCategory        category);
GnomeVFSFileSize ob_category_files_get_size           (ObCategoryFiles  *files,
						       int               categories);
int              ob_category_files_get_num_files      (ObCategoryFiles  *files,
						       int               categories);
GSList *         ob_category_files_get_file_entries   (ObCategoryFiles  *files,
						       ObCategory        category);

G_END_DECLS

#endif /* OB_CATEGORY_H_ */





