/*
 * This file is part of osso-backup
 *
 * Copyright (C) 2005-2006 Nokia Corporation.
 *
 * Contact: Andrey Kochanov <andrey.kochanov@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef OB_BACKUP_LOCATIONS_H_
#define OB_BACKUP_LOCATIONS_H_

#include <time.h>
#include <glib.h>
#include <libgnomevfs/gnome-vfs.h>

#include "ob-types.h"

G_BEGIN_DECLS

typedef struct _ObBackupLocations ObBackupLocations;

void               ob_backup_locations_init            (const char        *config_dir);
ObBackupLocations *ob_backup_locations_get             (void);
void               ob_backup_locations_shutdown        (void);
gboolean           ob_backup_locations_is_included     (ObBackupLocations *locations,
							const char        *path);
gboolean           ob_backup_locations_is_auto_restore (ObBackupLocations *locations,
							const char        *path);
GList *            ob_backup_locations_get_uris        (ObBackupLocations *locations,
							gint               categories,
							gboolean           excluded);
void               ob_backup_locations_count_data      (ObBackupLocations *locations,
							int                categories,
							int               *num_files,
							GnomeVFSFileSize  *size);

/*
 * Private API, only exposed for the tests and only needed when adding locations
 * manually.
 */
gboolean _ob_backup_locations_init_empty          (void);
gboolean _ob_backup_locations_add_location        (ObBackupLocations *locations,
						   const char        *path,
						   ObCategory         category,
						   gboolean           is_dir,
						   gboolean           is_auto,
						   gboolean           is_exclusion);
void     _ob_backup_locations_remove_redundancies (ObBackupLocations *locations);


G_END_DECLS

#endif /* OB_BACKUP_LOCATIONS_H_ */



