/*
 * This file is part of osso-backup
 *
 * Copyright (C) 2005-2006 Nokia Corporation.
 *
 * Contact: Andrey Kochanov <andrey.kochanov@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef OB_BACKUP_INFO_H_
#define OB_BACKUP_INFO_H_

#include <time.h>
#include <glib.h>
#include <libgnomevfs/gnome-vfs.h>

#include "ob-types.h"
#include "ob-memory-card.h"

G_BEGIN_DECLS

#define OB_BACKUP_INFO(x) ((ObBackupInfo *) x)
typedef struct _ObBackupInfo ObBackupInfo;

#define OB_TYPE_BACKUP_INFO ob_backup_info_get_type()

ObBackupInfo *   ob_backup_info_new                          (GnomeVFSURI      *uri,
							      time_t            timestamp,
							      gboolean          is_protected,
							      const char       *password,
							      const char       *device_version,
							      gint              categories);
ObBackupInfo *   ob_backup_info_dup                          (ObBackupInfo     *info);
ObBackupInfo *   ob_backup_info_ref                          (ObBackupInfo     *info);
void             ob_backup_info_unref                        (ObBackupInfo     *info);
char *           ob_backup_info_get_name                     (ObBackupInfo     *info);
GnomeVFSURI *    ob_backup_info_get_uri                      (ObBackupInfo     *info);
GnomeVFSFileSize ob_backup_info_get_size                     (ObBackupInfo     *info);
int              ob_backup_info_get_num_files                (ObBackupInfo     *info);
time_t           ob_backup_info_get_timestamp                (ObBackupInfo     *info);
gboolean         ob_backup_info_get_is_protected             (ObBackupInfo     *info);
const char *     ob_backup_info_get_password                 (ObBackupInfo     *info);
const char *     ob_backup_info_get_device_version           (ObBackupInfo     *info);
gint             ob_backup_info_get_categories               (ObBackupInfo     *info);
void             ob_backup_info_set_timestamp                (ObBackupInfo     *info,
							      time_t            timestamp);
void             ob_backup_info_set_categories               (ObBackupInfo     *info,
							      int               categories);
void             ob_backup_info_set_is_protected             (ObBackupInfo     *info,
							      gboolean          is_protected);
void             ob_backup_info_set_password                 (ObBackupInfo     *info,
							      const gchar      *password);
void             ob_backup_info_set_data_amount              (ObBackupInfo     *info,
							      ObCategory        category,
							      GnomeVFSFileSize  size,
							      int               num_files);
void             ob_backup_info_get_data_amount              (ObBackupInfo     *info,
							      ObCategory        category,
							      GnomeVFSFileSize *size,
							      int              *num_files);
GList *          ob_backup_info_list_get                     (GnomeVFSURI      *location);
void             ob_backup_info_list_free                    (GList            *list);
GnomeVFSResult   ob_backup_info_create_dir                   (ObBackupInfo     *info);
GnomeVFSResult   ob_backup_info_remove_dir                   (ObBackupInfo     *info);
GnomeVFSResult   ob_backup_info_write_metadata               (ObBackupInfo     *info);
GnomeVFSFileSize ob_backup_info_get_size_for_categories      (ObBackupInfo     *info,
							      int               categories);
int              ob_backup_info_get_num_files_for_categories (ObBackupInfo     *info,
							      int               categories);
char *           ob_backup_info_get_category_archive_path    (ObBackupInfo     *info,
							      ObCategory        category);
void             ob_backup_info_reset_categories             (ObBackupInfo     *info,
							      int               categories);
void             ob_backup_info_print                        (ObBackupInfo     *info);
gboolean         ob_backup_info_check_password               (ObBackupInfo     *info,
							      const char       *password);
ObMemoryCardType ob_backup_info_get_card_type                (ObBackupInfo     *info);
GType            ob_backup_info_get_type                     (void);

G_END_DECLS

#endif /* OB_BACKUP_INFO_H_ */

