/**
    @file texts.h

    Maemo-Blocks text printing functions header

  This file is part of Maemo Blocks

  Copyright (C) 2006 Nokia Corporation
 
  This software is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License
  as published by the Free Software Foundation; either version 2.1 of
  the License, or (at your option) any later version.
 
  This software is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.
 
  You should have received a copy of the GNU Lesser General Public
  License along with this software; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  02110-1301 USA
*/



#ifndef FT_H
#define FT_H

#include <SDL/SDL.h>
#include <ft2build.h>
#include FT_FREETYPE_H


/**
 Initialize the freetype2 library
 @return 0 on success, 1 otherwise
*/
int Text_Init(void);

/**
 Prints the game over strings to the destination
 @param destination The destination surface
 @return 0 on succes, non-0 on fail
*/
int Print_game_over(SDL_Surface *destination);

/**
 Prints the restart string to the destination
 @param destination The destination surface
 @return 0 on succes, non-0 on fail
*/
int Print_restart(SDL_Surface *destination);

/**
 Prints the exit to menu string to the destination
 @param destination The destination surface
 @return 0 on succes, non-0 on fail
*/
int Print_exit_to_menu(SDL_Surface *destination);

/**
 Prints the next string to the destination
 @param destination The destination surface
 @return 0 on succes, non-0 on fail
*/
int Print_next(SDL_Surface *destination);

/**
 Prints the level string to the destination
 @param destination The destination surface
 @return 0 on succes, non-0 on fail
*/
int Print_level(SDL_Surface *destination);

/**
 Prints the scrore string to the destination
 @param destination The destination surface
 @return 0 on succes, non-0 on fail
*/
int Print_score(SDL_Surface *destination);

/**
 Prints the lines string to the destination
 @param destination The destination surface
 @return 0 on succes, non-0 on fail
*/
int Print_lines(SDL_Surface *destination);

/**
 Convert the degree into radian
 @param degree The degree which needs to be converted
 @return The radian number
*/
float convert_degree_to_radian(float degree);


#endif /* FT_H */
