/**
    @file game.h

    Maemo-Blocks game headers.

  This file is part of Maemo Blocks

  Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
  http://www.indt.org/maemo
 
  This software is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License
  as published by the Free Software Foundation; either version 2.1 of
  the License, or (at your option) any later version.
 
  This software is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.
 
  You should have received a copy of the GNU Lesser General Public
  License along with this software; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  02110-1301 USA
*/


#ifndef _GAME_H_
#define _GAME_H_

#define true                1
#define false               0

#define MAX_X               10
#define MAX_Y               20
#define BLOCKS              7

#define NUM_LEVELS          20
#define NUM_HIGHSCORE       10

#define DIFFICULTY_LEVEL    "/apps/indt/maemoblocks/difficulty_level"
#define NOISE_LEVEL         "/apps/indt/maemoblocks/noise_level"
#define NOISE_HEIGHT        "/apps/indt/maemoblocks/noise_height"

extern int matrix[MAX_Y][MAX_X];
extern int next_block, next_frame;
extern int lines_score[4];
extern int cur_x, cur_y, cur_block, cur_frame;
extern int num_blocks[BLOCKS];
extern int current_score, current_level, current_lines, game_over, block_selected;
extern int blocks[BLOCKS][4], level_speeds[NUM_LEVELS];
extern unsigned int delay;

/**
  Init game
*/
inline void game_init(void);

/**
  Move block horizontally
*/
int move_block(int dx, int dy);

/**
  Change block's frame
*/
int change_frame(void);

/**
  Knock down the block
*/
int move_down(void);

/**
  Init game screen
*/
void game_new_wrapper(int new_level, int new_noise_level, int new_noise_height);
	

#endif //_GAME_H_
