/**
    @file callbacks.h

    Maemo-Blocks callback function headers for libshadow

  This file is part of Maemo Blocks

  Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
  http://www.indt.org/maemo
 
  This software is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License
  as published by the Free Software Foundation; either version 2.1 of
  the License, or (at your option) any later version.
 
  This software is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.
 
  You should have received a copy of the GNU Lesser General Public
  License along with this software; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  02110-1301 USA
*/
#ifndef _CALLBACKS_H_
#define _CALLBACKS_H_

#if SAPP_FUNC
/** The context of the lobshadow */
extern sapp_data *sapp_context;
#endif
/**
  Exit callback for libshadow. Pause the game
  @param errcode the error code
  @return 0 on success
*/
int exit_callback(int errcode/*, AppData *app_data*/);

/**
  Quit callback for libshadow. Close the game
  @param errcode the error code
  @return 0 on success
*/
int quit_callback(int errcode/*, AppData *app_data*/);

/**
  Flush callback for libshadow.
  @param errcode the error code
  @return 0 on success
*/
int flush_callback(int errcode);

#endif //_CALLBACKS_H_
