/*
 * Copyright (C) 2007 Tuomas Kulve <tuomas@kulve.fi>
 * Copyright (C) 2007 Kalle Vahlman <zuh@iki.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#include <glib.h> /* g_spawn */
#include <glibmm.h>
#include <gtkmm.h>


class InitDWindow : public Gtk::Dialog
{
 
public:
    InitDWindow();
    virtual ~InitDWindow();

    void add_script(Glib::ustring script);

    void start_clicked(Glib::ustring script);
    void stop_clicked(Glib::ustring script);
    void boot_clicked(Gtk::CheckButton *bootcb, Glib::ustring script);

    void execute(Glib::ustring script, Glib::ustring action);
    void child_exit(GPid pid, gint status, gpointer data);

    Gtk::ScrolledWindow swin;
    Gtk::VBox box;
    Gtk::Label heading;
  
};



InitDWindow::InitDWindow()
{
    Gtk::VBox *mainbox;
    set_title ("InitD");
    
    heading.set_markup("<big><b>Initscripts found on the machine</b></big> ");
    heading.show();
    box.pack_start(heading, false, false, 12);
    
    mainbox = get_vbox(); 
    mainbox->pack_start(swin, true, true, 0);
    swin.set_policy(Gtk::POLICY_NEVER, Gtk::POLICY_ALWAYS);
    swin.add(box);

    add_button(Gtk::Stock::CLOSE, Gtk::RESPONSE_OK);

    Glib::Dir dir ("/etc/init.d");
    
    Glib::ustring entry = dir.read_name();
    
    while (!entry.empty())
    {
        add_script(entry);
        entry = dir.read_name();
    }

    mainbox->show_all();
}



void
InitDWindow::start_clicked(Glib::ustring script)
{
    execute(script, "start");
}



void
InitDWindow::stop_clicked(Glib::ustring script)
{
    execute(script, "stop");
}

void
InitDWindow::boot_clicked(Gtk::CheckButton *bootcb, Glib::ustring script)
{
    if (bootcb->get_active()) {
        execute(script, "booton");
    } else {
        execute(script, "bootoff");
    }
}


void
InitDWindow::add_script(Glib::ustring script)
{
    Gtk::HBox *hbox = Gtk::manage(new Gtk::HBox(0, true));
    Gtk::Label *label = Gtk::manage(new Gtk::Label(script));
    Gtk::Button *startb = Gtk::manage(new Gtk::Button("Start"));
    Gtk::Button *stopb = Gtk::manage(new Gtk::Button("Stop"));
    Gtk::CheckButton *bootcb = 
        Gtk::manage(new Gtk::CheckButton("Start on boot"));
    
    label->set_alignment(0.0, 0.5);
    label->show();

    Glib::Dir dir ("/etc/rc2.d");

    Glib::ustring entry = dir.read_name();

    while (!entry.empty())
    {
        if (entry.substr(3) == script)
        {
            bootcb->set_active(true);
        }
        entry = dir.read_name();
    }

    hbox->pack_start(*label, true, true, 6);
    hbox->pack_start(*bootcb, false, false, 6);
    hbox->pack_start(*startb, false, false, 6);
    hbox->pack_start(*stopb, false, false, 6);

    startb->signal_clicked().
        connect(sigc::bind<Glib::ustring>(
                    sigc::mem_fun(*this, &InitDWindow::start_clicked),
                    script));
    stopb->signal_clicked().
        connect(sigc::bind<Glib::ustring>(
                    sigc::mem_fun(*this, &InitDWindow::stop_clicked),
                    script));
    bootcb->signal_clicked().
        connect(sigc::bind<Gtk::CheckButton *, Glib::ustring>(
                    sigc::mem_fun(*this, &InitDWindow::boot_clicked),
                    bootcb, script));

    box.add(*hbox);

}

void InitDWindow::execute(Glib::ustring script, Glib::ustring action)
{
    gchar *argv[] = {"/usr/bin/service_kicker", 
                     (gchar*)script.c_str(),
                     (gchar*)action.c_str(),
                     NULL};
    GPid pid;
    GError *err = NULL;

    g_debug("Executing: %s %s %s", argv[1], argv[2], argv[3]);

    g_spawn_async(NULL, argv, NULL, (GSpawnFlags)0, NULL, NULL, &pid, &err);
    if (err != NULL) {
        /* FIXME: add infoprint */
        g_warning("Failed to execute: %s", err->message);
        g_error_free(err);
        return;
    }

    /*g_child_watch_add(pid, child_exit, NULL);*/
}

#if 0
void InitDWindow::child_exit(GPid pid, gint status, gpointer data)
{
    /* FIXME: show infoprint about execution success */
}
#endif

InitDWindow::~InitDWindow()
{
}


int main(int argc, char** argv)
{
    Gtk::Main app (&argc, &argv);

    InitDWindow dialog;
    
    dialog.set_size_request(600, 300);
    dialog.show_all_children();

	dialog.run();

	return 0;
}             


/* Emacs indentatation information
   Local Variables:
   indent-tabs-mode:nil
   tab-width:4
   c-file-style:"stroustrup"
   c-set-offset:4
   c-basic-offset:4
   End:
*/
