/*
 * Copyright (C) 2007 Kalle Vahlman <zuh@iki.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 *
 * --
 *
 * CPA-launcher is a stub for launching non-C Control Panel applets
 * This code doesn't need to be modified, the launchee name is passed
 * as the CPAPPLET_BINARY define on the compile command line.
 */

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>

#ifndef CPAPPLET_BINARY
#error "Applet launcher not properly configured, binary name was not defined"
#endif

static
gboolean
handle_hup                            (GIOChannel *source,
                                       GIOCondition condition,
                                       gpointer data);

osso_return_t execute(osso_context_t *osso, 
					  gpointer data, 
					  gboolean user_activated)
{
        gchar *run_args[2];
        GtkWidget *win;
        GError *error;
        GMainLoop *loop;
        GIOChannel *channel;
        gint fd;
        
        win = GTK_WIDGET(g_object_new(GTK_TYPE_WINDOW, NULL));
        gtk_window_set_modal(GTK_WINDOW(win), TRUE);

        run_args[0] = g_strdup(CPAPPLET_BINARY);
        run_args[1] = NULL;
  
        error = NULL;
        if (!g_spawn_async_with_pipes (NULL,
                                       (gchar**)&run_args, NULL,
                                       0, NULL, NULL,
                                       NULL,
                                       NULL, NULL, &fd,
                                       &error))
        {
                g_error ("Unable to spawn applet '%s': %s",
                         CPAPPLET_BINARY,
                         error->message);
                return OSSO_OK;
        }

        g_free(run_args[0]);

        loop = g_main_loop_new (NULL, FALSE);
        channel = g_io_channel_unix_new (fd);
        g_io_add_watch (channel, G_IO_HUP, (GIOFunc) handle_hup, loop);

        GDK_THREADS_LEAVE ();  
        g_main_loop_run (loop);
        GDK_THREADS_ENTER ();  

        g_main_loop_unref (loop);

        loop = NULL;

	return OSSO_OK;
}

static
gboolean
handle_hup                            (GIOChannel *source,
                                       GIOCondition condition,
                                       gpointer data)
{
        /* We don't allow mistakes */
        g_assert (data != NULL);
        g_main_loop_quit((GMainLoop*)data);
        return FALSE;
}

