/*
 * This file is part of Maemo Examples
 *
 * Copyright (C) 2005-2007 Nokia Corporation.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <hildon-widgets/hildon-app.h>
#include <hildon-fm/hildon-widgets/hildon-file-chooser-dialog.h>
#include <gtk/gtk.h>

/* Application UI data struct */
typedef struct _AppData AppData;
struct _AppData {
	GtkWidget *app;
	GtkWidget *appview;
	
	GtkWidget * main_vbox;
	GtkWidget * label;

	/* Menu stuff */
	GtkMenu   * main_menu;
	GtkWidget * menu_item_file_open;
	GtkWidget * menu_item_file_save;
	GtkWidget * menu_item_quit;
};

void example_show_test_result (AppData * data, gchar * test_name, gchar * test_result)
{
	gchar * label_text = g_strdup_printf ("File Chooser Example.\n\n%s:\n\n%s.", test_name, test_result);
	gtk_label_set_text (GTK_LABEL (data->label), label_text);
	g_free(label_text);
}

gchar * interface_file_chooser (AppData * appdata, GtkFileChooserAction action)
{
	GtkWidget *dialog;
	gchar *filename = NULL;
	
	dialog = hildon_file_chooser_dialog_new (GTK_WINDOW (appdata->app), action);
	gtk_widget_show_all (GTK_WIDGET (dialog));

	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK) {
		filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
	}

	gtk_widget_destroy(dialog);
	return filename;
}

void cb_example_file_open (GtkWidget * w, AppData * data)
{
	gchar *filename = NULL;
	    
	filename = interface_file_chooser (data, GTK_FILE_CHOOSER_ACTION_OPEN);

	if (filename == NULL) {
		filename = "NULL";
	}

	example_show_test_result (data, "Open File", filename);
}

void cb_example_file_save (GtkWidget * w, AppData * data)
{
	gchar *filename = NULL;
	filename = interface_file_chooser (data, GTK_FILE_CHOOSER_ACTION_SAVE);

	if (filename == NULL) {
		filename = "NULL";
	}
	else {
		FILE * f = fopen (filename, "w");
		fprintf (f, "This file was generated by Hildon File Chooser example.");
		fclose (f);
	}

	example_show_test_result (data, "File saved as", filename);

	
}

void cb_example_quit (GtkWidget *w, AppData * data)
{
	gtk_main_quit ();
}

void example_create_menu (AppData * data)
{
	data->main_menu = hildon_appview_get_menu (HILDON_APPVIEW (data->appview));

	/* Create Menu items and connect signals */
	data->menu_item_file_open = gtk_menu_item_new_with_label ("Test File Open");
	g_signal_connect (G_OBJECT (data->menu_item_file_open), "activate", G_CALLBACK (cb_example_file_open), data);

	data->menu_item_file_save = gtk_menu_item_new_with_label ("Test File Save");
	g_signal_connect (G_OBJECT (data->menu_item_file_save), "activate", G_CALLBACK (cb_example_file_save), data);

	data->menu_item_quit = gtk_menu_item_new_with_label ("Quit");
	g_signal_connect (G_OBJECT (data->menu_item_quit), "activate", G_CALLBACK (cb_example_quit), NULL);

	/* Append items to menu */
	gtk_menu_append (data->main_menu, data->menu_item_file_open);
	gtk_menu_append (data->main_menu, data->menu_item_file_save);
	gtk_menu_append (data->main_menu, gtk_separator_menu_item_new());
	gtk_menu_append (data->main_menu, data->menu_item_quit);

	gtk_widget_show_all (GTK_WIDGET (data->main_menu));
}

void example_init (AppData * data)
{
	/* Create Hildon App */
	data->app = hildon_app_new ();
	hildon_app_set_title (HILDON_APP (data->app), "File Chooser Example");

	/* Create Hildon Appview */
	data->appview = hildon_appview_new ("File Chooser Example");
	hildon_app_set_appview (HILDON_APP (data->app), HILDON_APPVIEW (data->appview));

	/* Add main vbox to appview */
	data->main_vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (data->appview), data->main_vbox);

	/* Add label to main vbox */
	data->label = gtk_label_new ("File Chooser Example.\n\nClick on Menu for test list.");
	gtk_box_pack_start (GTK_BOX (data->main_vbox), data->label, TRUE, TRUE, 0);

	gtk_widget_show_all (data->app);

	/* Create Menu */
	example_create_menu (data);
}


int main(int argc, char *argv[])
{
	AppData * data = g_new0 (AppData, 1);

	gtk_init(&argc, &argv);

	example_init (data);

	gtk_main();

	g_free (data);
    	return 0;
}
