/*
 * This file is part of libgst0.10-dsp
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Stefan Kost <stefan.kost@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef __GST_DSPPCMRC_H__
#define __GST_DSPPCMSRC_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gst/gst.h>
#include <gst/base/gstpushsrc.h>

#include <dspaudio.h>
#include <dsp/audio_dsptask.h>
#include <dsp/interface_common.h>

G_BEGIN_DECLS

#define GST_TYPE_DSPPCMSRC            (gst_dsppcmsrc_get_type())
#define GST_DSPPCMSRC(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_DSPPCMSRC,GstDSPPCMSrc))
#define GST_DSPPCMSRC_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_DSPPCMSRC,GstDSPPCMSrcClass))
#define GST_IS_DSPPCMSRC(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_DSPPCMSRC))
#define GST_IS_DSPPCMSRC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_DSPPCMSRC))

typedef enum
{
  DSPPCM_PROP_DTX_MODE = DSPAUDIO_PROP_LAST,
  DSPPCM_PROP_LAST
} DSPPCMProperties;

typedef struct _GstDSPPCMSrc GstDSPPCMSrc;
typedef struct _GstDSPPCMSrcClass GstDSPPCMSrcClass;


struct _GstDSPPCMSrc {
  GstPushSrc    parent;
  GstDSPAudio   *audio;
  GstClock      *clock;
  guint         framesize;
  guint         frametimemillis;
  guint         format;
  guint         devindex;
  gint64        framecount;
  gboolean      dtx_enabled;
  gboolean      raw;

  GstDSPAudioDTXModes dtxmode;
  GstPad          *cnpad;
  GstBuffer       *lastcn;
};

struct _GstDSPPCMSrcClass {
  GstPushSrcClass parent_class;
};


GType gst_dsppcmsrc_get_type(void);

G_END_DECLS

#endif /* __GST_DSPPCMSRC_H__ */
