/*
 * This file is part of libgst0.10-dsp
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Stefan Kost <stefan.kost@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef __GST_DSPG729RC_H__
#define __GST_DSPG729SRC_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gst/gst.h>
#include <gst/base/gstpushsrc.h>

#include <dspaudio.h>
#include <dsp/audio_dsptask.h>
#include <dsp/interface_common.h>

G_BEGIN_DECLS

#define GST_TYPE_DSPG729SRC          (gst_dspg729src_get_type())
#define GST_DSPG729SRC(obj)          (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_DSPG729SRC,GstDSPG729Src))
#define GST_DSPG729SRC_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_DSPG729SRC,GstDSPG729SrcClass))
#define GST_IS_DSPG729SRC(obj)       (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_DSPG729SRC))
#define GST_IS_DSPG729SRC_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_DSPG729SRC))

typedef struct _GstDSPG729Src GstDSPG729Src;
typedef struct _GstDSPG729SrcClass GstDSPG729SrcClass;

typedef enum
{
  DSPG729_PROP_DTX_MODE = DSPAUDIO_PROP_LAST,
  DSPG729_PROP_LAST
} DSPG729Properties;

struct _GstDSPG729Src {
  GstPushSrc    parent;
  GstDSPAudio   *audio;
  GstClock      *clock;
  GstBuffer     *lastcn;
  gint64        framecount;
  guint         framesize;
  guint         frametimemillis;
  guint         cn_counter;

  GstDSPAudioDTXModes dtxmode;
};

struct _GstDSPG729SrcClass {
  GstPushSrcClass parent_class;
};


GType gst_dspg729src_get_type(void);

G_END_DECLS

#endif /* __GST_DSPG729SRC_H__ */
