/*
 * src/sm_drv_wpa.h
 *
 * WPA definitions for Conexant ISL_3825 chipset.
 *
 * Copyright (C) 2004, 2005, 2006 Nokia Corporation
 * Author: Samuel Ortiz <samuel.ortiz@nokia.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */
#ifndef _SM_DRV_WPA_H
#define _SM_DRV_WPA_H

/* Wireless extensions extensions...*/
#define IW_ENCODE_TKIP       0x0200
#define IW_ENCODE_AES        0x0100
#define IW_ENCODE_UNICAST    0x0080
#define IW_ENCODE_MULTICAST  0x0040

/* Authentication order flags. We let the 8 first
   bits free for WE-17 */
#define IW_AUTH_MASK            0xff00
#define IW_AUTH_NOWPA           0x100
#define IW_AUTH_WPA             0x200
#define IW_AUTH_WPA_PSK         0x300
#define IW_AUTH_WPA2            0x400
#define IW_AUTH_WPA2_PSK        0x500

/* Privacy invoked when calling set_wpa */
#define DOT11_PRIV_INV_NONE                     0
#define DOT11_PRIV_INV_WEP                      1
#define DOT11_PRIV_INV_TKIP                     2
#define DOT11_PRIV_INV_AES_CCMP                 3

/* Generic IE to pass to the driver */
typedef struct generic_element{
	/*
	 * If len is 0, we detach the generic element from the
	 * frames.
	 */
	__u8   len;
	__u8*  data;
} generic_element;

#define CRYPT_ALG_NAME_LEN 16
typedef struct wlan_crypt {
	__u8   alg[CRYPT_ALG_NAME_LEN];
	__u32  flags; // IW_ENCODE_*
	__u32  err;
	__u8   idx;
	__u8   seq[8]; /* sequence counter (set: RX, get: TX) */
	__u16  key_len;
	__u8   key[0];
} wlan_crypt;


/* Private ioctls numbers */
#define SM_DRV_WPA_SCAN                          SIOCIWFIRSTPRIV + 2
#define SM_DRV_WPA_GEN_ELT                       SIOCIWFIRSTPRIV + 4
#define SM_DRV_WPA_SET_WPA                       SIOCIWFIRSTPRIV + 6
#define SM_DRV_WPA_GET_WPA                       SIOCIWFIRSTPRIV + 7
#define SM_DRV_WPA_SET_KEY                       SIOCIWFIRSTPRIV + 8
/* SET_KEY needs to be on an odd index for getting NET_ADMIN capabilities */
#define SM_DRV_WPA_SET_KEY_NET_ADMIN             SIOCIWFIRSTPRIV + 9
#define SM_DRV_WPA_PMK_SET_KEY                   SIOCIWFIRSTPRIV + 10 

#endif
