/*
 * src/sm_drv_sysfs.h
 *
 *
 * Copyright (C) 2004, 2005, 2006 Nokia Corporation
 * Author: Samuel Ortiz <samuel.ortiz@nokia.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef _SM_DRV_SYSFS_H
#define _SM_DRV_SYSFS_H

/*
 * Abusing macros to factorise simple u32 read/write.
 */
#define sm_drv_sysfs_ru32_attr(field, oid)				               \
static ssize_t sm_drv_show_##field(struct device *dev, struct device_attribute *attr,  \
				   char *buf)	                                       \
{									               \
        int ret, answer;                                                               \
        ret = sm_drv_oid_get((struct net_device *)dev_get_drvdata(dev),                \
			     (oid),                                                    \
			     &answer,                                                  \
			     sizeof(uint32_t));                                        \
	return sprintf(buf, "%d\n", answer);			                       \
}									 

#define sm_drv_sysfs_wu32_attr(field, oid)			                         \
static ssize_t sm_drv_store_##field(struct device *dev, struct device_attribute *attr,   \
				    const char *buf, size_t count)	                 \
{									                 \
        int ret;                                                                         \
        int value = simple_strtoul(buf, NULL, 0);                                        \
        DEBUG(DBG_SYSFS, "Setting value: %d for OID: 0x%x\n", value, oid);               \
        ret = sm_drv_oid_set((struct net_device *)dev_get_drvdata(dev),                  \
			     (oid),                                                      \
			     &value,                                                     \
			     sizeof(uint32_t));                                          \
        if (ret < 0)                                                                     \
		return 0;                                                                \
		                                                                         \
	return count;							                 \
}									 


int sm_drv_register_platform(struct net_device * sm_drv);
void sm_drv_unregister_platform(void);
int sm_drv_sysfs_create_files(void);
int sm_drv_sysfs_umac_create_files(void);

#endif
