/*
 * src/sm_drv_spi_io.h
 *
 * OMAP SPI wrapper for Conexant Softmac driver.
 *
 * Copyright (C) 2004, 2005, 2006 Nokia Corporation
 * Author: Samuel Ortiz <samuel.ortiz@nokia.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */


#ifndef _SM_DRV_SPI_IO_H
#define _SM_DRV_SPI_IO_H

#ifdef CONFIG_MACH_NOKIA_N800
#include <linux/spi/spi.h>
#endif

int cx3110x_request_irq(irqreturn_t (*handler)(int, void *, struct pt_regs *),
			  const char * devname, void *dev_id);
void cx3110x_free_irq(void *dev_id);
void cx3110x_disable_irq(struct net_device *dev);

int cx3110x_spi_start(struct net_device *dev);
void cx3110x_spi_stop(struct net_device *dev);

#ifdef CONFIG_MACH_NOKIA_N800
int cx3110x_probe(struct spi_device *spi);
int cx3110x_remove(struct spi_device *spi);
#endif

int cx3110x_spi_read(struct net_device * dev, unsigned long address, unsigned char * buffer, unsigned int length);
int cx3110x_spi_write(struct net_device * dev, unsigned long address, unsigned char * buffer, unsigned int length);
int cx3110x_spi_dma_read(struct net_device *dev, unsigned long address, void * buffer, unsigned int length);
int cx3110x_spi_dma_write(struct net_device *dev, unsigned long address, void * buffer, unsigned int length);

void cx3110x_dump_register(struct net_device * dev);

#define sm_spi_read(dev, addr, data, len)     cx3110x_spi_read(dev, (addr), (data), (len))  
#define sm_spi_write(dev, addr, data, len)    cx3110x_spi_write(dev, (addr), (data), (len))

#define sm_spi_dma_read(dev, addr, data, len)     cx3110x_spi_dma_read(dev, (addr), (data), (len))
#define sm_spi_dma_write(dev, addr, data, len)    cx3110x_spi_dma_write(dev, (addr), (data), (len))

#endif
