#include <cybergarage/upnp/cupnp.h>
#include <string.h>
#include <stdio.h>
#include "common.h"

/**
 * Notify Listener
 */
void SSDPNotifyListener(CgUpnpSSDPPacket *ssdpPkt)
{
	char *st;
	char *nt;
	char *url;
	char *server;
	char *nts;
	char *man;
	char *usn;
	if (cg_upnp_ssdp_packet_isdiscover(ssdpPkt) == TRUE) {
		st = cg_upnp_ssdp_packet_getst(ssdpPkt);
		nt = cg_upnp_ssdp_packet_getnt(ssdpPkt);
		url = cg_upnp_ssdp_packet_getlocation(ssdpPkt);
		server = cg_upnp_ssdp_packet_getserver(ssdpPkt);
		nts = cg_upnp_ssdp_packet_getnts(ssdpPkt);
		man = cg_upnp_ssdp_packet_getman(ssdpPkt);
		usn = cg_upnp_ssdp_packet_getusn(ssdpPkt);
		fprintf( stderr, "ssdp:discover : ST = %s | NT = %s | location = %s | server = %s | nts = %s | man = %s | usn = %s\n",
			st, nt, url, server, nts, man, usn); 
	}
	else if (cg_upnp_ssdp_packet_isalive(ssdpPkt) == TRUE) {
		fprintf( stderr, "ssdp:alive : uuid = %s, NT = %s, location = %s\n",
			cg_upnp_ssdp_packet_getusn(ssdpPkt), 
			cg_upnp_ssdp_packet_getnt(ssdpPkt), 
			cg_upnp_ssdp_packet_getlocation(ssdpPkt)); 
	}
	else if (cg_upnp_ssdp_packet_isbyebye(ssdpPkt) == TRUE) {
		fprintf( stderr, "ssdp:byebye : uuid = %s, NT = %s\n",
			cg_upnp_ssdp_packet_getusn(ssdpPkt), 
			cg_upnp_ssdp_packet_getnt(ssdpPkt));
	}
	cg_upnp_ssdp_packet_print(ssdpPkt); 
}

int main( int argc, char* argv[] )
{
	CgUpnpDevice *dev = cg_upnp_device_new();

	const char *top_srcdir = getenv("top_srcdir");
	const char *fname = "/tests/regression/mini_dev.xml";
	int len = strlen(top_srcdir) + strlen(fname) + 1;
	char full_name[len];
	strcpy(full_name, top_srcdir);
	strcat(full_name, fname);
	cg_upnp_device_loaddescriptionfile(dev, full_name);

	cg_upnp_device_setleasetime(dev, 1);
	cg_upnp_device_start(dev);
	
	cg_wait( 500 );
	
	CgUpnpControlPoint *ctrlPoint;
	ctrlPoint = cg_upnp_controlpoint_new();
	cg_upnp_controlpoint_setssdplistener(ctrlPoint, SSDPNotifyListener);
	cg_upnp_controlpoint_start(ctrlPoint);

	printf(SYNC_STRING);
	fflush(NULL);
	getchar();	

	cg_upnp_device_stop(dev);
	cg_upnp_device_delete(dev);

	return(0);
}
