#!/usr/bin/python

import BaseHTTPServer
import os
import signal

def base_http_server(msgs):
    class Handler (BaseHTTPServer.BaseHTTPRequestHandler):
        def do_GET(self):
            res = msgs[self.path]
            self.send_response(200)
            self.end_headers()
            self.wfile.write(res)

        def do_SUBSCRIBE(self):
            self.send_response(200)
            self.send_header('SID', 'abc')
            self.end_headers()
            self.wfile.write('oi\n')

        def do_NOTIFY(self):
            self.send_response(200)
            self.end_headers()
            self.wfile.write('oi\n')

        def do_POST(self):
            size = self.headers['Content-Length']
            data = self.rfile.read(int(size))
            if 'QueryStateVariable' in self.headers['SOAPACTION']:
                self.send_response(200)
            elif 'Good Bye' in data:
                self.send_response(400)
            else:
                self.send_response(200)
            self.end_headers()
            if 'Hello World' in data:
                self.wfile.write('<a><b><c><detail><UPnPError>abc</UPnPError></detail></c></b></a>\n')
            else:
                self.wfile.write('<a><b><c><:detail><UPnPError>abc</UPnPError></:detail></c></b></a>\n')

    server_address = ('', 8765)
    httpd = BaseHTTPServer.HTTPServer(server_address, Handler)
    return httpd

class http_server:
    def __init__(self, msgs):
        pid = os.fork()
        if pid == 0:
            httpd = base_http_server(msgs)
            httpd.serve_forever()
        else:
            self.pid = pid

    def __del__(self):
        os.kill(self.pid, signal.SIGKILL)
        os.waitpid(self.pid, 0)

def start_http_server(msgs):
    return http_server(msgs)
