/******************************************************************
*
*	CyberNet for C
*
*	Copyright (C) Satoshi Konno 2005
*
*       Copyright (C) 2006 Nokia Corporation. All rights reserved.
*
*       This is licensed under BSD-style license with patent exclusion,
*       see file COPYING.
*
*	File: csubscriber_list.c
*
*	Revision:
*
*	06/21/05
*		- first revision
*
******************************************************************/

#include <cybergarage/upnp/event/csubscriber.h>
#include <cybergarage/util/clog.h>

/****************************************
* CG_UPNP_NOUSE_SUBSCRIPTION (Begin)
****************************************/

#if !defined(CG_UPNP_NOUSE_SUBSCRIPTION)

/****************************************
* cg_upnp_subscriberlist_new
****************************************/

CgUpnpSubscriberList *cg_upnp_subscriberlist_new()
{
	cg_log_debug_l4("Entering...\n");

	CgUpnpSubscriberList *subscriberList = (CgUpnpSubscriberList *)malloc(sizeof(CgUpnpSubscriberList));

	if ( NULL != subscriberList )
		cg_list_header_init((CgList *)subscriberList);

	return subscriberList;

	cg_log_debug_l4("Leaving...\n");
}

/****************************************
* cg_upnp_subscriberlist_delete
****************************************/

void cg_upnp_subscriberlist_delete(CgUpnpSubscriberList *subscriberList)
{
	cg_log_debug_l4("Entering...\n");

	cg_upnp_subscriberlist_clear(subscriberList);
	free(subscriberList);

	cg_log_debug_l4("Leaving...\n");
}

/****************************************
* CG_UPNP_NOUSE_SUBSCRIPTION (End)
****************************************/

#endif
